/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.ui.UiPreferencesService;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="ui/preferences")
public class UiPreferencesWebResource
extends AbstractWebResource {
    @GET
    @Produces(value={"application/json"})
    public Response download() {
        UiPreferencesService service = (UiPreferencesService)this.get(UiPreferencesService.class);
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        service.getUserNames().forEach(user -> {
            ObjectNode prefs = mapper.createObjectNode();
            root.set(user, (JsonNode)prefs);
            service.getPreferences(user).forEach((arg_0, arg_1) -> ((ObjectNode)prefs).set(arg_0, arg_1));
        });
        return UiPreferencesWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="{user}")
    @Produces(value={"application/json"})
    public Response download(@PathParam(value="user") String user) {
        UiPreferencesService service = (UiPreferencesService)this.get(UiPreferencesService.class);
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode prefs = mapper.createObjectNode();
        service.getPreferences(user).forEach((arg_0, arg_1) -> ((ObjectNode)prefs).set(arg_0, arg_1));
        return UiPreferencesWebResource.ok((Object)prefs).build();
    }

    @GET
    @Path(value="{user}/{pref}")
    @Produces(value={"application/json"})
    public Response download(@PathParam(value="user") String user, @PathParam(value="pref") String pref) {
        UiPreferencesService service = (UiPreferencesService)this.get(UiPreferencesService.class);
        return UiPreferencesWebResource.ok((Object)Tools.nullIsNotFound((Object)service.getPreference(user, pref), (String)"No such preference")).build();
    }

    @PUT
    @Path(value="{user}/{pref}")
    @Produces(value={"application/json"})
    public Response upload(@PathParam(value="user") String user, @PathParam(value="pref") String pref, String request) throws IOException {
        UiPreferencesService service = (UiPreferencesService)this.get(UiPreferencesService.class);
        ObjectNode json = (ObjectNode)this.mapper().readTree(request);
        service.setPreference(user, pref, json);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{user}/{pref}")
    @Produces(value={"application/json"})
    public Response remove(@PathParam(value="user") String user, @PathParam(value="pref") String pref) {
        UiPreferencesService service = (UiPreferencesService)this.get(UiPreferencesService.class);
        service.setPreference(user, pref, null);
        return Response.noContent().build();
    }
}

