/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import java.io.InputStream;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.codec.CodecContext;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="applications")
public class ApplicationsWebResource
extends AbstractWebResource {
    @GET
    public Response getApplications() {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        Set apps = service.getApplications();
        return ApplicationsWebResource.ok((Object)this.encodeArray(Application.class, "applications", (Iterable)apps)).build();
    }

    @GET
    @Path(value="{name}")
    public Response getApplication(@PathParam(value="name") String name) {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        ApplicationId appId = service.getId(name);
        return this.response(service, appId);
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response installApplication(@QueryParam(value="activate") @DefaultValue(value="false") boolean activate, InputStream stream) {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        Application app = service.install(stream);
        if (activate) {
            service.activate(app.id());
        }
        return ApplicationsWebResource.ok((Object)this.codec(Application.class).encode((Object)app, (CodecContext)this)).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="{name}")
    public Response uninstallApplication(@PathParam(value="name") String name) {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        ApplicationId appId = service.getId(name);
        service.uninstall(appId);
        return Response.ok().build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{name}/active")
    public Response activateApplication(@PathParam(value="name") String name) {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        ApplicationId appId = service.getId(name);
        service.activate(appId);
        return this.response(service, appId);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="{name}/active")
    public Response deactivateApplication(@PathParam(value="name") String name) {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        ApplicationId appId = service.getId(name);
        service.deactivate(appId);
        return this.response(service, appId);
    }

    private Response response(ApplicationAdminService service, ApplicationId appId) {
        Application app = service.getApplication(appId);
        return ApplicationsWebResource.ok((Object)this.codec(Application.class).encode((Object)app, (CodecContext)this)).build();
    }
}

