/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.onlab.packet.ChassisId;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Frequency;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.GridType;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.OchPort;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduCltPort;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.OmsPort;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.OchPortDescription;
import org.onosproject.net.device.OduCltPortDescription;
import org.onosproject.net.device.OmsPortDescription;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.rest.resources.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigProvider
implements DeviceProvider,
LinkProvider,
HostProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final ProviderId PID = new ProviderId("cfg", "org.onosproject.rest", true);
    private static final String UNKNOWN = "unknown";
    private static final Frequency CENTER = Frequency.ofTHz((double)193.1);
    private static final Frequency TOTAL = Frequency.ofTHz((double)4.4);
    private CountDownLatch deviceLatch;
    private final JsonNode cfg;
    private final DeviceService deviceService;
    private final DeviceProviderRegistry deviceProviderRegistry;
    private final LinkProviderRegistry linkProviderRegistry;
    private final HostProviderRegistry hostProviderRegistry;
    private DeviceProviderService deviceProviderService;
    private LinkProviderService linkProviderService;
    private HostProviderService hostProviderService;
    private DeviceListener deviceEventCounter = new DeviceEventCounter(this, null);
    private List<ConnectPoint> connectPoints = Lists.newArrayList();
    private Map<ConnectPoint, PortDescription> descriptions = Maps.newHashMap();

    ConfigProvider(JsonNode cfg, DeviceService deviceService, DeviceProviderRegistry deviceProviderRegistry, LinkProviderRegistry linkProviderRegistry, HostProviderRegistry hostProviderRegistry) {
        this.cfg = (JsonNode)Preconditions.checkNotNull((Object)cfg, (Object)"Configuration cannot be null");
        this.deviceService = (DeviceService)Preconditions.checkNotNull((Object)deviceService, (Object)"Device service cannot be null");
        this.deviceProviderRegistry = (DeviceProviderRegistry)Preconditions.checkNotNull((Object)deviceProviderRegistry, (Object)"Device provider registry cannot be null");
        this.linkProviderRegistry = (LinkProviderRegistry)Preconditions.checkNotNull((Object)linkProviderRegistry, (Object)"Link provider registry cannot be null");
        this.hostProviderRegistry = (HostProviderRegistry)Preconditions.checkNotNull((Object)hostProviderRegistry, (Object)"Host provider registry cannot be null");
    }

    void parse() {
        try {
            this.register();
            this.parseDevices();
            this.parseLinks();
            this.parseHosts();
            this.addMissingPorts();
        }
        finally {
            this.unregister();
        }
    }

    private void register() {
        this.deviceProviderService = (DeviceProviderService)this.deviceProviderRegistry.register((Provider)this);
        this.linkProviderService = (LinkProviderService)this.linkProviderRegistry.register((Provider)this);
        this.hostProviderService = (HostProviderService)this.hostProviderRegistry.register((Provider)this);
    }

    private void unregister() {
        this.deviceProviderRegistry.unregister((Provider)this);
        this.linkProviderRegistry.unregister((Provider)this);
        this.hostProviderRegistry.unregister((Provider)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDevices() {
        try {
            JsonNode nodes = this.cfg.get("devices");
            if (nodes != null) {
                this.prepareForDeviceEvents(nodes.size());
                for (JsonNode node : nodes) {
                    this.parseDevice(node);
                    this.parseDevice(node);
                }
            }
        }
        finally {
            this.waitForDeviceEvents();
        }
    }

    private void parseDevice(JsonNode node) {
        URI uri = URI.create(this.get(node, "uri"));
        Device.Type type = Device.Type.valueOf((String)this.get(node, "type", "SWITCH"));
        String mfr = this.get(node, "mfr", UNKNOWN);
        String hw = this.get(node, "hw", UNKNOWN);
        String sw = this.get(node, "sw", UNKNOWN);
        String serial = this.get(node, "serial", UNKNOWN);
        ChassisId cid = new ChassisId(this.get(node, "mac", "000000000000"));
        SparseAnnotations annotations = this.annotations(node.get("annotations"));
        DefaultDeviceDescription desc = new DefaultDeviceDescription(uri, type, mfr, hw, sw, serial, cid, new SparseAnnotations[]{annotations});
        DeviceId deviceId = DeviceId.deviceId((URI)uri);
        this.deviceProviderService.deviceConnected(deviceId, (DeviceDescription)desc);
        JsonNode ports = node.get("ports");
        if (ports != null) {
            this.parsePorts(deviceId, ports);
        }
    }

    private void parsePorts(DeviceId deviceId, JsonNode nodes) {
        ArrayList<PortDescription> ports = new ArrayList<PortDescription>();
        for (JsonNode node : nodes) {
            ports.add(this.parsePort(deviceId, node));
        }
        this.deviceProviderService.updatePorts(deviceId, ports);
    }

    private PortDescription parsePort(DeviceId deviceId, JsonNode node) {
        Port.Type type = Port.Type.valueOf((String)node.path("type").asText("COPPER"));
        PortNumber port = null;
        if (node.has("name")) {
            for (Port p : this.deviceService.getPorts(deviceId)) {
                if (!p.number().name().equals(node.get("name").asText())) continue;
                port = p.number();
                break;
            }
        } else {
            port = PortNumber.portNumber((long)node.path("port").asLong(0L));
        }
        if (port == null) {
            this.log.error("Cannot find port given in node {}", (Object)node);
            return null;
        }
        String portName = Strings.emptyToNull((String)port.name());
        DefaultAnnotations annotations = null;
        if (portName != null) {
            annotations = DefaultAnnotations.builder().set("portName", portName).build();
        }
        switch (1.$SwitchMap$org$onosproject$net$Port$Type[type.ordinal()]) {
            case 1: {
                return new DefaultPortDescription(port, node.path("enabled").asBoolean(true), type, node.path("speed").asLong(1000L), new SparseAnnotations[]{annotations});
            }
            case 2: {
                return new OmsPortDescription(port, node.path("enabled").asBoolean(true), CENTER, CENTER.add(TOTAL), Frequency.ofGHz((double)100.0), new SparseAnnotations[]{annotations});
            }
            case 3: {
                annotations = this.annotations(node.get("annotations"));
                OduCltPort oduCltPort = (OduCltPort)this.deviceService.getPort(deviceId, port);
                return new OduCltPortDescription(port, node.path("enabled").asBoolean(true), oduCltPort.signalType(), new SparseAnnotations[]{annotations});
            }
            case 4: {
                annotations = this.annotations(node.get("annotations"));
                OchPort ochPort = (OchPort)this.deviceService.getPort(deviceId, port);
                return new OchPortDescription(port, node.path("enabled").asBoolean(true), ochPort.signalType(), ochPort.isTunable(), ochPort.lambda(), new SparseAnnotations[]{annotations});
            }
            case 5: {
                annotations = this.annotations(node.get("annotations"));
                OmsPort omsPort = (OmsPort)this.deviceService.getPort(deviceId, port);
                return new OmsPortDescription(port, node.path("enabled").asBoolean(true), omsPort.minFrequency(), omsPort.maxFrequency(), omsPort.grid(), new SparseAnnotations[]{annotations});
            }
        }
        this.log.warn("{}: Unsupported Port Type");
        return new DefaultPortDescription(port, node.path("enabled").asBoolean(true), type, node.path("speed").asLong(1000L), new SparseAnnotations[]{annotations});
    }

    private void parseLinks() {
        JsonNode nodes = this.cfg.get("links");
        if (nodes != null) {
            for (JsonNode node : nodes) {
                this.parseLink(node, false);
                if (node.has("halfplex")) continue;
                this.parseLink(node, true);
            }
        }
    }

    private void parseLink(JsonNode node, boolean reverse) {
        ConnectPoint src = this.connectPoint(this.get(node, "src"));
        ConnectPoint dst = this.connectPoint(this.get(node, "dst"));
        Link.Type type = Link.Type.valueOf((String)this.get(node, "type", "DIRECT"));
        SparseAnnotations annotations = this.annotations(node.get("annotations"));
        this.updatePorts(src, dst, annotations);
        DefaultLinkDescription desc = reverse ? new DefaultLinkDescription(dst, src, type, new SparseAnnotations[]{annotations}) : new DefaultLinkDescription(src, dst, type, new SparseAnnotations[]{annotations});
        this.linkProviderService.linkDetected((LinkDescription)desc);
        this.connectPoints.add(src);
        this.connectPoints.add(dst);
    }

    private void updatePorts(ConnectPoint src, ConnectPoint dst, SparseAnnotations annotations) {
        String linkType = annotations.value("optical.type");
        if ("cross-connect".equals(linkType)) {
            String value = annotations.value("bandwidth").trim();
            try {
                double bw = Double.parseDouble(value);
                this.updateOchPort(bw, src, dst);
            }
            catch (NumberFormatException e) {
                this.log.warn("Invalid bandwidth ({}), can't configure port(s)", (Object)value);
                return;
            }
        }
        if ("WDM".equals(linkType)) {
            String value = annotations.value("optical.waves").trim();
            try {
                int numChls = Integer.parseInt(value);
                this.updateOMSPorts(numChls, src, dst);
            }
            catch (NumberFormatException e) {
                this.log.warn("Invalid channel ({}), can't configure port(s)", (Object)value);
                return;
            }
        }
    }

    private void updateOchPort(double bw, ConnectPoint srcCp, ConnectPoint dstCp) {
        OchPortDescription portDesc;
        Device src = this.deviceService.getDevice(srcCp.deviceId());
        Device dst = this.deviceService.getDevice(dstCp.deviceId());
        Frequency spacing = Frequency.ofMHz((double)bw);
        ChannelSpacing chsp = null;
        if (spacing.compareTo(ChannelSpacing.CHL_6P25GHZ.frequency()) <= 0) {
            chsp = ChannelSpacing.CHL_6P25GHZ;
        }
        for (int i = 1; i < ChannelSpacing.values().length; ++i) {
            Frequency val = ChannelSpacing.values()[i].frequency();
            if (!val.isLessThan((Object)spacing)) continue;
            chsp = ChannelSpacing.values()[i - 1];
            break;
        }
        if (chsp == null) {
            this.log.warn("Invalid channel spacing ({}), can't configure port(s)", (Object)spacing);
            return;
        }
        OchSignal signal = new OchSignal(GridType.DWDM, chsp, 1, 1);
        if (src.type() == Device.Type.ROADM) {
            portDesc = new OchPortDescription(srcCp.port(), true, OduSignalType.ODU4, true, signal, new SparseAnnotations[0]);
            this.descriptions.put(srcCp, portDesc);
            this.deviceProviderService.portStatusChanged(srcCp.deviceId(), (PortDescription)portDesc);
        }
        if (dst.type() == Device.Type.ROADM) {
            portDesc = new OchPortDescription(dstCp.port(), true, OduSignalType.ODU4, true, signal, new SparseAnnotations[0]);
            this.descriptions.put(dstCp, portDesc);
            this.deviceProviderService.portStatusChanged(dstCp.deviceId(), (PortDescription)portDesc);
        }
    }

    private void updateOMSPorts(int numChls, ConnectPoint srcCp, ConnectPoint dstCp) {
        ChannelSpacing chl = null;
        Frequency perChl = TOTAL.floorDivision((long)numChls);
        for (int i = 0; i < ChannelSpacing.values().length; ++i) {
            Frequency val = ChannelSpacing.values()[i].frequency();
            if (!val.isLessThan((Object)perChl)) continue;
            chl = ChannelSpacing.values()[i];
            break;
        }
        if (chl == null) {
            chl = ChannelSpacing.CHL_6P25GHZ;
        }
        Frequency grid = chl == null ? Frequency.ofGHz((double)100.0) : chl.frequency();
        Frequency min = CENTER.add(grid);
        Frequency max = CENTER.add(grid.multiply((long)numChls));
        OmsPortDescription srcPortDesc = new OmsPortDescription(srcCp.port(), true, min, max, grid, new SparseAnnotations[0]);
        OmsPortDescription dstPortDesc = new OmsPortDescription(dstCp.port(), true, min, max, grid, new SparseAnnotations[0]);
        this.descriptions.put(srcCp, srcPortDesc);
        this.descriptions.put(dstCp, dstPortDesc);
        this.deviceProviderService.portStatusChanged(srcCp.deviceId(), (PortDescription)srcPortDesc);
        this.deviceProviderService.portStatusChanged(dstCp.deviceId(), (PortDescription)dstPortDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseHosts() {
        try {
            JsonNode nodes = this.cfg.get("hosts");
            if (nodes != null) {
                for (JsonNode node : nodes) {
                    this.parseHost(node);
                    this.parseHost(node);
                }
            }
        }
        finally {
            this.hostProviderRegistry.unregister((Provider)this);
        }
    }

    private void parseHost(JsonNode node) {
        MacAddress mac = MacAddress.valueOf((String)this.get(node, "mac"));
        VlanId vlanId = VlanId.vlanId((short)((short)node.get("vlan").asInt(-1)));
        HostId hostId = HostId.hostId((MacAddress)mac, (VlanId)vlanId);
        SparseAnnotations annotations = this.annotations(node.get("annotations"));
        HostLocation location = new HostLocation(this.connectPoint(this.get(node, "location")), 0L);
        String[] ipStrings = this.get(node, "ip", "").split(",");
        HashSet<IpAddress> ips = new HashSet<IpAddress>();
        for (String ip : ipStrings) {
            ips.add(IpAddress.valueOf((String)ip.trim()));
        }
        DefaultHostDescription desc = new DefaultHostDescription(mac, vlanId, location, ips, new SparseAnnotations[]{annotations});
        this.hostProviderService.hostDetected(hostId, (HostDescription)desc);
        this.connectPoints.add(location);
    }

    private void addMissingPorts() {
        this.deviceService.getDevices().forEach(arg_0 -> this.addMissingPorts(arg_0));
    }

    private void addMissingPorts(Device device) {
        List ports = this.deviceService.getPorts(device.id());
        Set existing = ports.stream().map(p -> new ConnectPoint((ElementId)device.id(), p.number())).collect(Collectors.toSet());
        Set<ConnectPoint> missing = this.connectPoints.stream().filter(cp -> !existing.contains(cp)).collect(Collectors.toSet());
        if (!missing.isEmpty()) {
            ArrayList newPorts = Lists.newArrayList();
            ports.forEach(p -> newPorts.add(this.description(p)));
            missing.forEach(cp -> newPorts.add(this.description(cp)));
            this.deviceProviderService.updatePorts(device.id(), (List)newPorts);
        }
    }

    private PortDescription description(Port p) {
        switch (1.$SwitchMap$org$onosproject$net$Port$Type[p.type().ordinal()]) {
            case 5: {
                OmsPort op = (OmsPort)p;
                return new OmsPortDescription(op.number(), op.isEnabled(), op.minFrequency(), op.maxFrequency(), op.grid(), new SparseAnnotations[0]);
            }
            case 4: {
                OchPort ochp = (OchPort)p;
                return new OchPortDescription(ochp.number(), ochp.isEnabled(), ochp.signalType(), ochp.isTunable(), ochp.lambda(), new SparseAnnotations[0]);
            }
            case 3: {
                OduCltPort odup = (OduCltPort)p;
                return new OduCltPortDescription(odup.number(), odup.isEnabled(), odup.signalType(), new SparseAnnotations[0]);
            }
        }
        return new DefaultPortDescription(p.number(), p.isEnabled(), p.type(), p.portSpeed(), new SparseAnnotations[0]);
    }

    private PortDescription description(ConnectPoint cp) {
        PortDescription saved = (PortDescription)this.descriptions.get(cp);
        if (saved != null) {
            return saved;
        }
        Port p = this.deviceService.getPort(cp.deviceId(), cp.port());
        if (p == null) {
            return new DefaultPortDescription(cp.port(), true, new SparseAnnotations[0]);
        }
        return this.description(p);
    }

    private SparseAnnotations annotations(JsonNode node) {
        if (node == null) {
            return DefaultAnnotations.EMPTY;
        }
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String k = (String)it.next();
            builder.set(k, node.get(k).asText());
        }
        return builder.build();
    }

    private ConnectPoint connectPoint(String text) {
        int i = text.lastIndexOf("/");
        String portName = text.substring(i + 1);
        DeviceId deviceId = DeviceId.deviceId((String)text.substring(0, i));
        long portNum = 0L;
        for (Port port : this.deviceService.getPorts(deviceId)) {
            PortNumber pn = port.number();
            if (!pn.name().equals(portName)) continue;
            return new ConnectPoint((ElementId)deviceId, pn);
        }
        return new ConnectPoint((ElementId)deviceId, PortNumber.portNumber((long)portNum, (String)portName));
    }

    private String get(JsonNode node, String name) {
        return node.path(name).asText();
    }

    private String get(JsonNode node, String name, String defaultValue) {
        return node.path(name).asText(defaultValue);
    }

    public void roleChanged(DeviceId device, MastershipRole newRole) {
        this.deviceProviderService.receivedRoleReply(device, newRole, newRole);
    }

    public void triggerProbe(DeviceId deviceId) {
    }

    public void triggerProbe(Host host) {
    }

    public ProviderId id() {
        return PID;
    }

    public boolean isReachable(DeviceId device) {
        return true;
    }

    protected void prepareForDeviceEvents(int count) {
        this.deviceLatch = new CountDownLatch(count);
        this.deviceService.addListener(this.deviceEventCounter);
    }

    protected void waitForDeviceEvents() {
        try {
            this.deviceLatch.await(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.log.warn("Device events did not arrive in time");
        }
        this.deviceService.removeListener(this.deviceEventCounter);
    }

    static /* synthetic */ CountDownLatch access$100(ConfigProvider x0) {
        return x0.deviceLatch;
    }
}

