/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.rest.BaseResource;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.rest.resources.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="config")
public class ConfigWebResource
extends BaseResource {
    private static Logger log = LoggerFactory.getLogger(ConfigWebResource.class);

    @POST
    @Path(value="topology")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response topology(InputStream input) throws IOException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode cfg = mapper.readTree(input);
            new ConfigProvider(cfg, (DeviceService)this.get(DeviceService.class), (DeviceProviderRegistry)this.get(DeviceProviderRegistry.class), (LinkProviderRegistry)this.get(LinkProviderRegistry.class), (HostProviderRegistry)this.get(HostProviderRegistry.class)).parse();
            return Response.ok().build();
        }
        catch (Exception e) {
            log.error("Unable to parse topology configuration", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.toString()).build();
        }
    }
}

