/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.device.DeviceService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="devices")
public class DevicesWebResource
extends AbstractWebResource {
    public static final String DEVICE_NOT_FOUND = "Device is not found";

    @GET
    public Response getDevices() {
        Iterable devices = ((DeviceService)this.get(DeviceService.class)).getDevices();
        return DevicesWebResource.ok((Object)this.encodeArray(Device.class, "devices", devices)).build();
    }

    @GET
    @Path(value="{id}")
    public Response getDevice(@PathParam(value="id") String id) {
        Device device = (Device)Tools.nullIsNotFound((Object)((DeviceService)this.get(DeviceService.class)).getDevice(DeviceId.deviceId((String)id)), (String)"Device is not found");
        return DevicesWebResource.ok((Object)this.codec(Device.class).encode((Object)device, (CodecContext)this)).build();
    }

    @GET
    @Path(value="{id}/ports")
    public Response getDevicePorts(@PathParam(value="id") String id) {
        DeviceService service = (DeviceService)this.get(DeviceService.class);
        Device device = (Device)Tools.nullIsNotFound((Object)service.getDevice(DeviceId.deviceId((String)id)), (String)"Device is not found");
        List ports = (List)Preconditions.checkNotNull((Object)service.getPorts(DeviceId.deviceId((String)id)), (Object)"Ports could not be retrieved");
        ObjectNode result = this.codec(Device.class).encode((Object)device, (CodecContext)this);
        result.set("ports", (JsonNode)this.codec(Port.class).encode((Iterable)ports, (CodecContext)this));
        return DevicesWebResource.ok((Object)result).build();
    }
}

