/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="flows")
public class FlowsWebResource
extends AbstractWebResource {
    public static final String DEVICE_NOT_FOUND = "Device is not found";
    final FlowRuleService service = (FlowRuleService)this.get(FlowRuleService.class);
    final ObjectNode root = this.mapper().createObjectNode();
    final ArrayNode flowsNode = this.root.putArray("flows");

    @GET
    @Produces(value={"application/json"})
    public Response getFlows() {
        Iterable devices = ((DeviceService)this.get(DeviceService.class)).getDevices();
        for (Device device : devices) {
            Iterable deviceEntries = this.service.getFlowEntries(device.id());
            if (deviceEntries == null) continue;
            for (FlowEntry entry : deviceEntries) {
                this.flowsNode.add((JsonNode)this.codec(FlowEntry.class).encode((Object)entry, (CodecContext)this));
            }
        }
        return FlowsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}")
    public Response getFlowByDeviceId(@PathParam(value="deviceId") String deviceId) {
        Iterable deviceEntries = this.service.getFlowEntries(DeviceId.deviceId((String)deviceId));
        if (!deviceEntries.iterator().hasNext()) {
            throw new ItemNotFoundException("Device is not found");
        }
        for (FlowEntry entry : deviceEntries) {
            this.flowsNode.add((JsonNode)this.codec(FlowEntry.class).encode((Object)entry, (CodecContext)this));
        }
        return FlowsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}/{flowId}")
    public Response getFlowByDeviceIdAndFlowId(@PathParam(value="deviceId") String deviceId, @PathParam(value="flowId") long flowId) {
        Iterable deviceEntries = this.service.getFlowEntries(DeviceId.deviceId((String)deviceId));
        if (!deviceEntries.iterator().hasNext()) {
            throw new ItemNotFoundException("Device is not found");
        }
        for (FlowEntry entry : deviceEntries) {
            if (entry.id().value() != flowId) continue;
            this.flowsNode.add((JsonNode)this.codec(FlowEntry.class).encode((Object)entry, (CodecContext)this));
        }
        return FlowsWebResource.ok((Object)this.root).build();
    }
}

