/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.rest.resources.IntentsWebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="intents")
public class IntentsWebResource
extends AbstractWebResource {
    private static final Logger log = LoggerFactory.getLogger(IntentsWebResource.class);
    private static final int WITHDRAW_EVENT_TIMEOUT_SECONDS = 5;
    public static final String INTENT_NOT_FOUND = "Intent is not found";

    @GET
    @Produces(value={"application/json"})
    public Response getIntents() {
        Iterable intents = ((IntentService)this.get(IntentService.class)).getIntents();
        ObjectNode root = this.encodeArray(Intent.class, "intents", intents);
        return IntentsWebResource.ok((Object)root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{appId}/{key}")
    public Response getIntentById(@PathParam(value="appId") Short appId, @PathParam(value="key") String key) {
        ApplicationId app = ((CoreService)this.get(CoreService.class)).getAppId(appId);
        Intent intent = ((IntentService)this.get(IntentService.class)).getIntent(Key.of((String)key, (ApplicationId)app));
        if (intent == null) {
            intent = ((IntentService)this.get(IntentService.class)).getIntent(Key.of((long)Long.parseLong(key), (ApplicationId)app));
        }
        Tools.nullIsNotFound((Object)intent, (String)"Intent is not found");
        ObjectNode root = intent instanceof HostToHostIntent ? this.codec(HostToHostIntent.class).encode((Object)((HostToHostIntent)intent), (CodecContext)this) : (intent instanceof PointToPointIntent ? this.codec(PointToPointIntent.class).encode((Object)((PointToPointIntent)intent), (CodecContext)this) : this.codec(Intent.class).encode((Object)intent, (CodecContext)this));
        return IntentsWebResource.ok((Object)root).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{appId}/{key}")
    public void deleteIntentById(@PathParam(value="appId") Short appId, @PathParam(value="key") String keyString) {
        ApplicationId app = ((CoreService)this.get(CoreService.class)).getAppId(appId);
        Intent intent = ((IntentService)this.get(IntentService.class)).getIntent(Key.of((String)keyString, (ApplicationId)app));
        IntentService service = (IntentService)this.get(IntentService.class);
        if (intent == null) {
            intent = service.getIntent(Key.of((long)Long.parseLong(keyString), (ApplicationId)app));
        }
        if (intent == null) {
            return;
        }
        Key key = intent.key();
        CountDownLatch latch = new CountDownLatch(1);
        DeleteListener listener = new DeleteListener(this, key, latch);
        service.addListener((IntentListener)listener);
        try {
            service.withdraw(intent);
            try {
                latch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.info("REST Delete operation timed out waiting for intent {}", (Object)key);
            }
            IntentState state = service.getIntentState(key);
            if (state == IntentState.WITHDRAWN || state == IntentState.FAILED) {
                service.purge(intent);
            }
        }
        finally {
            service.removeListener((IntentListener)listener);
        }
    }
}

