/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.onosproject.rest.ApiDocProvider;
import org.onosproject.rest.ApiDocService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ApiDocService.class})
public class ApiDocManager
implements ApiDocService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ApiDocProvider> providers = Maps.newConcurrentMap();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public void register(ApiDocProvider provider) {
        this.providers.put(provider.key(), provider);
        this.log.info("{} registered at {}", (Object)provider.name(), (Object)provider.key());
    }

    public void unregister(ApiDocProvider provider) {
        this.providers.remove(provider.name());
        this.log.info("{} unregistered", (Object)provider.name());
    }

    public Set<ApiDocProvider> getDocProviders() {
        return ImmutableSet.copyOf(this.providers.values());
    }

    public ApiDocProvider getDocProvider(String key) {
        return (ApiDocProvider)this.providers.get(key);
    }
}

