/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.onlab.util.Tools;
import org.onosproject.rest.AbstractInjectionResource;
import org.onosproject.rest.ApiDocProvider;
import org.onosproject.rest.ApiDocService;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="docs")
public class ApiDocResource
extends AbstractInjectionResource {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String STYLESHEET = "text/css";
    private static final String SCRIPT = "text/javascript";
    private static final String DOCS = "/docs/";
    private static final String INJECT_START = "<!-- {API-START} -->";
    private static final String INJECT_END = "<!-- {API-END} -->";
    @Context
    private UriInfo uriInfo;

    @GET
    @Path(value="apis")
    public Response getApiList() {
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode apis = this.newArray(root, "apis");
        ((ApiDocService)this.get(ApiDocService.class)).getDocProviders().forEach(p -> apis.add(p.name()));
        return ApiDocResource.ok((Object)root.toString()).build();
    }

    @GET
    @Path(value="apis/{key: .*?}/swagger.json")
    public Response getApi(@PathParam(value="key") String key) {
        Object k = key.startsWith("/") ? key : "/" + key;
        InputStream stream = ((ApiDocProvider)Tools.nullIsNotFound((Object)((ApiDocService)this.get(ApiDocService.class)).getDocProvider((String)k), (String)("REST API not found for " + (String)k))).docs();
        return ApiDocResource.ok((Object)Tools.nullIsNotFound((Object)stream, (String)("REST API docs not found for " + (String)k))).header("Content-Type", (Object)"application/json").build();
    }

    @GET
    @Path(value="apis/{key: .*?}/model.json")
    public Response getApiModel(@PathParam(value="name") String key) {
        Object k = key.startsWith("/") ? key : "/" + key;
        InputStream stream = ((ApiDocProvider)Tools.nullIsNotFound((Object)((ApiDocService)this.get(ApiDocService.class)).getDocProvider((String)k), (String)("REST API not found for " + (String)k))).model();
        return ApiDocResource.ok((Object)Tools.nullIsNotFound((Object)stream, (String)("REST API model not found for " + (String)k))).header("Content-Type", (Object)"application/json").build();
    }

    @GET
    public Response getDefault() throws IOException, URISyntaxException {
        return this.uriInfo.getPath().endsWith("/") ? this.getIndex() : Response.temporaryRedirect((URI)new URI(this.uriInfo.getPath() + "/")).build();
    }

    @GET
    @Path(value="index.html")
    public Response getIndex() throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("/docs/index.html");
        Tools.nullIsNotFound((Object)stream, (String)"index.html not found");
        String index = new String(ByteStreams.toByteArray((InputStream)stream));
        int p1s = this.split(index, 0, "<!-- {API-START} -->");
        int p1e = this.split(index, p1s, "<!-- {API-END} -->");
        int p2s = this.split(index, p1e, null);
        AbstractInjectionResource.StreamEnumeration streams = new AbstractInjectionResource.StreamEnumeration((AbstractInjectionResource)this, (List)ImmutableList.of((Object)this.stream(index, 0, p1s), (Object)this.includeOptions((ApiDocService)this.get(ApiDocService.class)), (Object)this.stream(index, p1e, p2s)));
        return ApiDocResource.ok((Object)new SequenceInputStream((Enumeration<? extends InputStream>)streams)).header("Content-Type", (Object)"text/html").build();
    }

    private InputStream includeOptions(ApiDocService service) {
        StringBuilder sb = new StringBuilder();
        service.getDocProviders().forEach(p -> sb.append("<option value=\"").append(p.key()).append("\"").append("/onos/v1".equals(p.key()) ? " selected>" : ">").append(p.name()).append("</option>"));
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    @GET
    @Path(value="{resource: .*}")
    public Response getResource(@PathParam(value="resource") String resource) throws IOException {
        if ("".equals(resource)) {
            return this.getIndex();
        }
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("/docs/" + resource);
        return ApiDocResource.ok((Object)Tools.nullIsNotFound((Object)stream, (String)(resource + " not found"))).header("Content-Type", (Object)ApiDocResource.contentType((String)resource)).build();
    }

    static String contentType(String resource) {
        return resource.endsWith(".html") ? "text/html" : (resource.endsWith(".css") ? "text/css" : (resource.endsWith(".js") ? "text/javascript" : "application/octet-stream"));
    }
}

