/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.rest.AbstractWebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="nextobjectives")
public class FlowObjectiveNextListWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @GET
    @Produces(value={"application/json"})
    public Response getObjNextids() {
        ObjectNode node = this.getGroupChainByIdJsonOutput(null, null);
        return Response.status((int)200).entity((Object)node).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="nextobjective/{nextId}")
    public Response getGroupChainByNextid(@PathParam(value="nextId") String nextId) {
        ObjectNode node = this.getGroupChainByIdJsonOutput(Integer.valueOf(Integer.parseInt(nextId)), null);
        return Response.status((int)200).entity((Object)node).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}")
    public Response getGroupChainByDeviceId(@PathParam(value="deviceId") String deviceId) {
        ObjectNode node = this.getGroupChainByIdJsonOutput(null, DeviceId.deviceId((String)deviceId));
        return Response.status((int)200).entity((Object)node).build();
    }

    private ObjectNode getGroupChainByIdJsonOutput(Integer nextId, DeviceId deviceId) {
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode connectionArray = this.mapper().createArrayNode();
        FlowObjectiveService service = (FlowObjectiveService)this.get(FlowObjectiveService.class);
        Map nextObjGroupMap = service.getNextMappingsChain();
        if (nextId == null && deviceId == null) {
            nextObjGroupMap.forEach((key, value) -> {
                ObjectNode mappingNode = this.mapper().createObjectNode();
                String keyString = String.format("NextId %s: %s", key.getLeft(), key.getRight());
                mappingNode.put(keyString, value.toString());
                connectionArray.add((JsonNode)mappingNode);
            });
        } else {
            nextObjGroupMap.forEach((key, value) -> {
                ObjectNode mappingNode = this.mapper().createObjectNode();
                if (((Integer)key.getLeft()).equals(nextId) || ((DeviceId)key.getRight()).equals((Object)deviceId)) {
                    List groupchain = value;
                    if (deviceId != null && groupchain != null) {
                        String keyString = String.format("NextId %s:", key.getLeft());
                        mappingNode.put(keyString, groupchain.toString());
                    } else if (groupchain != null) {
                        mappingNode.put("groupChain", groupchain.toString());
                    }
                    connectionArray.add((JsonNode)mappingNode);
                }
            });
        }
        root.put("obj-next-ids", (JsonNode)connectionArray);
        return root;
    }
}

