/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.host.HostAdminService;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.provider.Provider;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.rest.resources.HostsWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="hosts")
public class HostsWebResource
extends AbstractWebResource {
    @Context
    private UriInfo uriInfo;
    private static final String HOST_NOT_FOUND = "Host is not found";
    private static final String[] REMOVAL_KEYS = new String[]{"mac", "vlan", "locations", "ipAddresses", "auxLocations", "innerVlan", "outerTpid"};

    @GET
    @Produces(value={"application/json"})
    public Response getHosts() {
        Iterable hosts = ((HostService)this.get(HostService.class)).getHosts();
        ObjectNode root = this.encodeArray(Host.class, "hosts", hosts);
        return HostsWebResource.ok((Object)root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{id}")
    public Response getHostById(@PathParam(value="id") String id) {
        Host host = (Host)Tools.nullIsNotFound((Object)((HostService)this.get(HostService.class)).getHost(HostId.hostId((String)id)), (String)"Host is not found");
        ObjectNode root = this.codec(Host.class).encode((Object)host, (CodecContext)this);
        return HostsWebResource.ok((Object)root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{mac}/{vlan}")
    public Response getHostByMacAndVlan(@PathParam(value="mac") String mac, @PathParam(value="vlan") String vlan) {
        Host host = (Host)Tools.nullIsNotFound((Object)((HostService)this.get(HostService.class)).getHost(HostId.hostId((String)(mac + "/" + vlan))), (String)"Host is not found");
        ObjectNode root = this.codec(Host.class).encode((Object)host, (CodecContext)this);
        return HostsWebResource.ok((Object)root).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createAndAddHost(InputStream stream) {
        URI location;
        HostProviderRegistry hostProviderRegistry = (HostProviderRegistry)this.get(HostProviderRegistry.class);
        InternalHostProvider hostProvider = new InternalHostProvider(this);
        try {
            ObjectNode root = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            HostProviderService hostProviderService = (HostProviderService)hostProviderRegistry.register((Provider)hostProvider);
            hostProvider.setHostProviderService(hostProviderService);
            HostId hostId = hostProvider.parseHost((JsonNode)root);
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("hosts").path(hostId.mac().toString()).path(hostId.vlanId().toString());
            location = locationBuilder.build(new Object[0]);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        finally {
            hostProviderRegistry.unregister((Provider)hostProvider);
        }
        return Response.created((URI)location).build();
    }

    @DELETE
    @Path(value="{mac}/{vlan}")
    @Produces(value={"application/json"})
    public Response removeHost(@PathParam(value="mac") String mac, @PathParam(value="vlan") String vlan) {
        ((HostAdminService)this.get(HostAdminService.class)).removeHost(HostId.hostId((String)(mac + "/" + vlan)));
        return Response.noContent().build();
    }
}

