/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cfg.ConfigProperty;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Direction;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.link.LinkService;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.rest.resources.LinksWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="links")
public class LinksWebResource
extends AbstractWebResource {
    @GET
    @Produces(value={"application/json"})
    public Response getLinks(@QueryParam(value="device") String deviceId, @QueryParam(value="port") String port, @QueryParam(value="direction") String direction) {
        LinkService service = (LinkService)this.get(LinkService.class);
        Iterable links = deviceId != null && port != null ? this.getConnectPointLinks(new ConnectPoint((ElementId)DeviceId.deviceId((String)deviceId), PortNumber.portNumber((String)port)), direction, service) : (deviceId != null ? this.getDeviceLinks(DeviceId.deviceId((String)deviceId), direction, service) : service.getLinks());
        return LinksWebResource.ok((Object)this.encodeArray(Link.class, "links", links)).build();
    }

    private Iterable<Link> getConnectPointLinks(ConnectPoint point, String direction, LinkService service) {
        Direction dir = direction != null ? Direction.valueOf((String)direction.toUpperCase()) : Direction.ALL;
        switch (1.$SwitchMap$org$onosproject$net$Direction[dir.ordinal()]) {
            case 1: {
                return service.getIngressLinks(point);
            }
            case 2: {
                return service.getEgressLinks(point);
            }
        }
        return service.getLinks(point);
    }

    private Iterable<Link> getDeviceLinks(DeviceId deviceId, String direction, LinkService service) {
        Direction dir = direction != null ? Direction.valueOf((String)direction.toUpperCase()) : Direction.ALL;
        switch (1.$SwitchMap$org$onosproject$net$Direction[dir.ordinal()]) {
            case 1: {
                return service.getDeviceIngressLinks(deviceId);
            }
            case 2: {
                return service.getDeviceEgressLinks(deviceId);
            }
        }
        return service.getDeviceLinks(deviceId);
    }

    @GET
    @Path(value="{usestalelinkage}")
    @Produces(value={"application/json"})
    public Response getVanishStaleLink() {
        ObjectNode root = this.mapper().createObjectNode();
        ComponentConfigService useStaleLink = (ComponentConfigService)this.get(ComponentConfigService.class);
        for (ConfigProperty prop : useStaleLink.getProperties("org.onosproject.provider.lldp.impl.LldpLinkProvider")) {
            if (!prop.name().equals("useStaleLinkAge")) continue;
            root.put("active", Boolean.valueOf(prop.value()));
            break;
        }
        return LinksWebResource.ok((Object)root).build();
    }

    @POST
    @Path(value="{usestalelinkage}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setVanishStaleLink(InputStream stream) {
        try {
            ObjectNode root = (ObjectNode)this.mapper().readTree(stream);
            if (root.has("active")) {
                ComponentConfigService useStaleLink = (ComponentConfigService)this.get(ComponentConfigService.class);
                useStaleLink.setProperty("org.onosproject.provider.lldp.impl.LldpLinkProvider", "useStaleLinkAge", String.valueOf(root.get("active")));
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return Response.ok().build();
    }
}

