/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.meter.DefaultMeterRequest;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterRequest;
import org.onosproject.net.meter.MeterService;
import org.onosproject.rest.AbstractWebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="meters")
public class MetersWebResource
extends AbstractWebResource {
    @Context
    private UriInfo uriInfo;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEVICE_INVALID = "Invalid deviceId in meter creation request";
    private static final String METER_NOT_FOUND = "Meter is not found for ";
    private final MeterService meterService = (MeterService)this.get(MeterService.class);
    private final ObjectNode root = this.mapper().createObjectNode();
    private final ArrayNode metersNode = this.root.putArray("meters");

    @GET
    @Produces(value={"application/json"})
    public Response getMeters() {
        Collection meters = this.meterService.getAllMeters();
        if (meters != null) {
            meters.forEach(meter -> this.metersNode.add((JsonNode)this.codec(Meter.class).encode(meter, (CodecContext)this)));
        }
        return MetersWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}")
    public Response getMetersByDeviceId(@PathParam(value="deviceId") String deviceId) {
        DeviceId did = DeviceId.deviceId((String)deviceId);
        Collection meters = this.meterService.getMeters(did);
        if (meters != null) {
            meters.forEach(meter -> this.metersNode.add((JsonNode)this.codec(Meter.class).encode(meter, (CodecContext)this)));
        }
        return MetersWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{deviceId}/{meterId}")
    public Response getMeterByDeviceIdAndMeterId(@PathParam(value="deviceId") String deviceId, @PathParam(value="meterId") String meterId) {
        DeviceId did = DeviceId.deviceId((String)deviceId);
        MeterId mid = MeterId.meterId((long)Long.valueOf(meterId));
        Meter meter = (Meter)Tools.nullIsNotFound((Object)this.meterService.getMeter(did, mid), (String)("Meter is not found for " + mid.id()));
        this.metersNode.add((JsonNode)this.codec(Meter.class).encode((Object)meter, (CodecContext)this));
        return MetersWebResource.ok((Object)this.root).build();
    }

    @POST
    @Path(value="{deviceId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createMeter(@PathParam(value="deviceId") String deviceId, InputStream stream) {
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            JsonNode specifiedDeviceId = jsonTree.get("deviceId");
            if (specifiedDeviceId != null && !specifiedDeviceId.asText().equals(deviceId) || ((DeviceService)this.get(DeviceService.class)).getDevice(DeviceId.deviceId((String)deviceId)) == null) {
                throw new IllegalArgumentException("Invalid deviceId in meter creation request");
            }
            jsonTree.put("deviceId", deviceId);
            MeterRequest meterRequest = (MeterRequest)this.codec(MeterRequest.class).decode(jsonTree, (CodecContext)this);
            Meter meter = this.meterService.submit(meterRequest);
            UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path("meters").path(deviceId).path(Long.toString((Long)meter.id().id()));
            return Response.created((URI)locationBuilder.build(new Object[0])).build();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @DELETE
    @Path(value="{deviceId}/{meterId}")
    public Response deleteMeterByDeviceIdAndMeterId(@PathParam(value="deviceId") String deviceId, @PathParam(value="meterId") String meterId) {
        MeterId mid;
        DeviceId did = DeviceId.deviceId((String)deviceId);
        Meter tmpMeter = this.meterService.getMeter(did, mid = MeterId.meterId((long)Long.valueOf(meterId)));
        if (tmpMeter != null) {
            MeterRequest meterRequest = this.meterToMeterRequest(tmpMeter, "REMOVE");
            if (meterRequest != null) {
                this.meterService.withdraw(meterRequest, tmpMeter.id());
            }
        } else {
            this.log.warn("Meter {}, is not present", (Object)tmpMeter);
        }
        return Response.noContent().build();
    }

    private MeterRequest meterToMeterRequest(Meter meter, String operation) {
        MeterRequest meterRequest;
        if (meter == null) {
            return null;
        }
        MeterRequest.Builder builder = meter.isBurst() ? DefaultMeterRequest.builder().fromApp(meter.appId()).forDevice(meter.deviceId()).withUnit(meter.unit()).withBands(meter.bands()).burst() : DefaultMeterRequest.builder().fromApp(meter.appId()).forDevice(meter.deviceId()).withUnit(meter.unit()).withBands(meter.bands());
        switch (operation) {
            case "ADD": {
                meterRequest = builder.add();
                break;
            }
            case "REMOVE": {
                meterRequest = builder.remove();
                break;
            }
            default: {
                this.log.warn("Invalid operation {}.", (Object)operation);
                return null;
            }
        }
        return meterRequest;
    }
}

