/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.onlab.util.Tools;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Direction;
import org.onosproject.net.ModulationScheme;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.ModulationConfig;
import org.onosproject.net.device.DeviceService;
import org.onosproject.rest.AbstractWebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="modulation")
public class ModulationWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Context
    private UriInfo uriInfo;
    private static final String DEVICE_NOT_FOUND = "Device is not found";
    private static final String APP_ID_NOT_FOUND = "Application Id is not found";
    private static final String MODULATIONCONFIG_UNSUPPORTED = "Modulation Config is not supported";
    private static final String DEVICES = "modulationConfigDevices";
    private static final String DEVICE_ID = "deviceId";
    private static final String DEVICE_IDS = "modulationConfigDeviceIds";
    private static final String MODULATIONCONFIG_SUPPORTED = "modulationConfigSupported";
    private static final String TARGET_MODULATION = "targetModulation";
    private static final String TARGET_BITRATE = "targetBitRate";
    private static final String JSON_INVALID = "Invalid json input";
    private final ObjectMapper mapper = new ObjectMapper();

    @GET
    @Produces(value={"application/json"})
    public Response getModulationSupportedDevices() {
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode deviceIdsNode = root.putArray("modulationConfigDeviceIds");
        Iterable devices = ((DeviceService)this.get(DeviceService.class)).getDevices();
        if (devices != null) {
            for (Device d : devices) {
                if (this.getModulationConfig(d.id().toString()) == null) continue;
                deviceIdsNode.add(d.id().toString());
            }
        }
        return ModulationWebResource.ok((Object)root).build();
    }

    private ModulationConfig<Object> getModulationConfig(String id) {
        Device device = ((DeviceService)this.get(DeviceService.class)).getDevice(DeviceId.deviceId((String)id));
        if (device == null) {
            throw new IllegalArgumentException("Device is not found");
        }
        if (device.is(ModulationConfig.class)) {
            return (ModulationConfig)device.as(ModulationConfig.class);
        }
        return null;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response isModulationSupported(@PathParam(value="id") String id) {
        ObjectNode result = this.mapper.createObjectNode();
        result.put("modulationConfigSupported", this.getModulationConfig(id) != null);
        return ModulationWebResource.ok((Object)result).build();
    }

    @GET
    @Path(value="{id}/port")
    @Produces(value={"application/json"})
    public Response getConfigurablePortModulation(@PathParam(value="id") String id, @QueryParam(value="port_id") String portId) {
        ModulationConfig modulationConfig = this.getModulationConfig(id);
        if (modulationConfig == null) {
            throw new IllegalArgumentException("Modulation Config is not supported");
        }
        ObjectNode result = this.encode(id, modulationConfig, portId);
        return ModulationWebResource.ok((Object)result).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response setModulationScheme(InputStream stream) {
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            this.decode(jsonTree);
            return Response.ok().build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ObjectNode encode(String deviceId, ModulationConfig<Object> modulationConfig, String portId) {
        Preconditions.checkNotNull(modulationConfig, (Object)"ModulationConfig cannot be null");
        Direction component = Direction.ALL;
        PortNumber port = PortNumber.portNumber((String)portId);
        this.log.debug("Port Details for port_id : {} is \n {} ", (Object)portId, (Object)port);
        ModulationScheme modulation = (ModulationScheme)modulationConfig.getModulationScheme(port, (Object)component).get();
        this.log.debug("Modulation  fetched from driver : " + modulation.name());
        ObjectNode responseNode = this.mapper.createObjectNode();
        responseNode.put("deviceId", deviceId);
        responseNode.put("portId", portId);
        responseNode.put("modulation", modulation.name());
        return responseNode;
    }

    public void decode(ObjectNode json) {
        if (json == null || !json.isObject()) {
            throw new IllegalArgumentException("Invalid json input");
        }
        JsonNode devicesNode = json.get("modulationConfigDevices");
        if (!devicesNode.isObject()) {
            throw new IllegalArgumentException("Invalid json input");
        }
        Iterator deviceEntries = devicesNode.fields();
        while (deviceEntries.hasNext()) {
            Map.Entry deviceEntryNext = (Map.Entry)deviceEntries.next();
            String deviceId = (String)deviceEntryNext.getKey();
            ModulationConfig modulationConfig = this.getModulationConfig(deviceId);
            JsonNode portsNode = (JsonNode)deviceEntryNext.getValue();
            if (!portsNode.isObject()) {
                throw new IllegalArgumentException("Invalid json input");
            }
            Iterator portEntries = portsNode.fields();
            while (portEntries.hasNext()) {
                Map.Entry portEntryNext = (Map.Entry)portEntries.next();
                PortNumber portNumber = PortNumber.portNumber((String)((String)portEntryNext.getKey()));
                JsonNode componentsNode = (JsonNode)portEntryNext.getValue();
                Iterator componentEntries = componentsNode.fields();
                while (componentEntries.hasNext()) {
                    Direction direction = null;
                    Map.Entry componentEntryNext = (Map.Entry)componentEntries.next();
                    try {
                        direction = Direction.valueOf((String)((String)componentEntryNext.getKey()).toUpperCase());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    JsonNode bitRateNode = (JsonNode)componentEntryNext.getValue();
                    if (!bitRateNode.isObject()) {
                        throw new IllegalArgumentException("Invalid json input");
                    }
                    Long targetBitRate = bitRateNode.get("targetBitRate").asLong();
                    if (direction == null) continue;
                    modulationConfig.setModulationScheme(portNumber, (Object)direction, targetBitRate.longValue());
                }
            }
        }
    }

    @PUT
    @Path(value="set-modulation/{id}")
    @Consumes(value={"application/json"})
    public Response setPortModulation(@PathParam(value="id") String id, @QueryParam(value="port_id") String portId, @QueryParam(value="direction") String direction, @QueryParam(value="bitrate") long bitrate) {
        ModulationConfig modulationConfig = this.getModulationConfig(id);
        PortNumber portNumber = PortNumber.portNumber((String)portId);
        this.log.info("Port Details for port_id : {} is \n {} ", (Object)portId, (Object)portNumber);
        if (direction == null) {
            this.log.error("Direction cannot be null");
            return Response.status((int)400, (String)"Direction cannot be Null").build();
        }
        Direction component = Direction.valueOf((String)direction.toUpperCase());
        modulationConfig.setModulationScheme(portNumber, (Object)component, bitrate);
        return Response.ok().build();
    }
}

