/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.InvalidConfigException;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.SubjectFactory;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="network/configuration")
public class NetworkConfigWebResource
extends AbstractWebResource {
    private static final int MULTI_STATUS_RESPONE = 207;

    private String subjectClassNotFoundErrorString(String subjectClassKey) {
        return "Config for '" + subjectClassKey + "' not found";
    }

    private String subjectNotFoundErrorString(String subjectClassKey, String subjectKey) {
        return "Config for '" + subjectClassKey + "/" + subjectKey + "' not found";
    }

    private String configKeyNotFoundErrorString(String subjectClassKey, String subjectKey, String configKey) {
        return "Config for '" + subjectClassKey + "/" + subjectKey + "/" + configKey + "' not found";
    }

    private String subjectClassInvalidErrorString(String subjectClassKey) {
        return "Config for '" + subjectClassKey + "' is invalid";
    }

    private String subjectClassNotValidErrorString(String subjectClassKey) {
        return "subjectClassKey '" + subjectClassKey + "' not found";
    }

    @GET
    @Produces(value={"application/json"})
    public Response download() {
        NetworkConfigService service = (NetworkConfigService)this.get(NetworkConfigService.class);
        ObjectNode root = this.mapper().createObjectNode();
        service.getSubjectClasses().forEach(sc -> {
            SubjectFactory subjectFactory = service.getSubjectFactory(sc);
            this.produceJson(service, this.newObject(root, subjectFactory.subjectClassKey()), subjectFactory, sc);
        });
        return NetworkConfigWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="{subjectClassKey}")
    @Produces(value={"application/json"})
    public Response download(@PathParam(value="subjectClassKey") String subjectClassKey) {
        NetworkConfigService service = (NetworkConfigService)this.get(NetworkConfigService.class);
        ObjectNode root = this.mapper().createObjectNode();
        SubjectFactory subjectFactory = (SubjectFactory)Tools.nullIsNotFound((Object)service.getSubjectFactory(subjectClassKey), (String)this.subjectClassNotFoundErrorString(subjectClassKey));
        this.produceJson(service, root, subjectFactory, subjectFactory.subjectClass());
        return NetworkConfigWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="{subjectClassKey}/{subjectKey}")
    @Produces(value={"application/json"})
    public Response download(@PathParam(value="subjectClassKey") String subjectClassKey, @PathParam(value="subjectKey") String subjectKey) {
        NetworkConfigService service = (NetworkConfigService)this.get(NetworkConfigService.class);
        ObjectNode root = this.mapper().createObjectNode();
        SubjectFactory subjectFactory = (SubjectFactory)Tools.nullIsNotFound((Object)service.getSubjectFactory(subjectClassKey), (String)this.subjectClassNotFoundErrorString(subjectClassKey));
        this.produceSubjectJson(service, root, subjectFactory.createSubject(subjectKey), true, this.subjectNotFoundErrorString(subjectClassKey, subjectKey));
        return NetworkConfigWebResource.ok((Object)root).build();
    }

    @GET
    @Path(value="{subjectClassKey}/{subjectKey}/{configKey}")
    @Produces(value={"application/json"})
    public Response download(@PathParam(value="subjectClassKey") String subjectClassKey, @PathParam(value="subjectKey") String subjectKey, @PathParam(value="configKey") String configKey) {
        NetworkConfigService service = (NetworkConfigService)this.get(NetworkConfigService.class);
        SubjectFactory subjectFactory = (SubjectFactory)Tools.nullIsNotFound((Object)service.getSubjectFactory(subjectClassKey), (String)this.subjectClassNotFoundErrorString(subjectClassKey));
        Object subject = Tools.nullIsNotFound((Object)subjectFactory.createSubject(subjectKey), (String)this.subjectNotFoundErrorString(subjectClassKey, subjectKey));
        Class configClass = (Class)Tools.nullIsNotFound((Object)service.getConfigClass(subjectClassKey, configKey), (String)this.configKeyNotFoundErrorString(subjectClassKey, subjectKey, configKey));
        Config config = (Config)Tools.nullIsNotFound((Object)service.getConfig(subject, configClass), (String)this.configKeyNotFoundErrorString(subjectClassKey, subjectKey, configKey));
        return NetworkConfigWebResource.ok((Object)config.node()).build();
    }

    private void produceJson(NetworkConfigService service, ObjectNode node, SubjectFactory subjectFactory, Class subjectClass) {
        service.getSubjects(subjectClass).forEach(s -> this.produceSubjectJson(service, this.newObject(node, subjectFactory.subjectKey(s)), s, false, ""));
    }

    private void produceSubjectJson(NetworkConfigService service, ObjectNode node, Object subject, boolean emptyIsError, String emptyErrorMessage) {
        Set configs = service.getConfigs(subject);
        if (emptyIsError) {
            configs = Tools.emptyIsNotFound((Set)configs, (String)emptyErrorMessage);
        }
        configs.forEach(c -> node.set(c.key(), c.node()));
    }

    @POST
    @Consumes(value={"application/json"})
    public Response upload(InputStream request) throws IOException {
        NetworkConfigService service = (NetworkConfigService)this.get(NetworkConfigService.class);
        ObjectNode root = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)request);
        ArrayList errorMsgs = new ArrayList();
        root.fieldNames().forEachRemaining(sk -> {
            if (service.getSubjectFactory(sk) == null) {
                errorMsgs.add(this.subjectClassNotValidErrorString(sk));
            } else if (!root.path(sk).isObject()) {
                errorMsgs.add(this.subjectClassInvalidErrorString(sk));
            } else {
                errorMsgs.addAll(this.consumeJson(service, (ObjectNode)root.path(sk), service.getSubjectFactory(sk)));
            }
        });
        if (!errorMsgs.isEmpty()) {
            return Response.status((int)207).entity((Object)this.produceErrorJson(errorMsgs)).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="{subjectClassKey}")
    @Consumes(value={"application/json"})
    public Response upload(@PathParam(value="subjectClassKey") String subjectClassKey, InputStream request) throws IOException {
        SubjectFactory subjectFactory;
        ObjectNode root;
        NetworkConfigService service = (NetworkConfigService)this.get(NetworkConfigService.class);
        List errorMsgs = this.consumeJson(service, root = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)request), subjectFactory = (SubjectFactory)Tools.nullIsNotFound((Object)service.getSubjectFactory(subjectClassKey), (String)this.subjectClassNotValidErrorString(subjectClassKey)));
        if (!errorMsgs.isEmpty()) {
            return Response.status((int)207).entity((Object)this.produceErrorJson(errorMsgs)).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="{subjectClassKey}/{subjectKey}")
    @Consumes(value={"application/json"})
    public Response upload(@PathParam(value="subjectClassKey") String subjectClassKey, @PathParam(value="subjectKey") String subjectKey, InputStream request) throws IOException {
        SubjectFactory subjectFactory;
        ObjectNode root;
        NetworkConfigService service = (NetworkConfigService)this.get(NetworkConfigService.class);
        List errorMsgs = this.consumeSubjectJson(service, root = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)request), (subjectFactory = (SubjectFactory)Tools.nullIsNotFound((Object)service.getSubjectFactory(subjectClassKey), (String)this.subjectClassNotValidErrorString(subjectClassKey))).createSubject(subjectKey), subjectClassKey);
        if (!errorMsgs.isEmpty()) {
            return Response.status((int)207).entity((Object)this.produceErrorJson(errorMsgs)).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="{subjectClassKey}/{subjectKey}/{configKey}")
    @Consumes(value={"application/json"})
    public Response upload(@PathParam(value="subjectClassKey") String subjectClassKey, @PathParam(value="subjectKey") String subjectKey, @PathParam(value="configKey") String configKey, InputStream request) throws IOException {
        NetworkConfigService service = (NetworkConfigService)this.get(NetworkConfigService.class);
        ObjectNode root = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)request);
        SubjectFactory subjectFactory = (SubjectFactory)Tools.nullIsNotFound((Object)service.getSubjectFactory(subjectClassKey), (String)this.subjectClassNotValidErrorString(subjectClassKey));
        service.applyConfig(subjectClassKey, subjectFactory.createSubject(subjectKey), configKey, (JsonNode)root);
        return Response.ok().build();
    }

    private List<String> consumeJson(NetworkConfigService service, ObjectNode classNode, SubjectFactory subjectFactory) {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        classNode.fieldNames().forEachRemaining(s -> {
            List error = this.consumeSubjectJson(service, (ObjectNode)classNode.path(s), subjectFactory.createSubject(s), subjectFactory.subjectClassKey());
            errorMsgs.addAll(error);
        });
        return errorMsgs;
    }

    private List<String> consumeSubjectJson(NetworkConfigService service, ObjectNode subjectNode, Object subject, String subjectClassKey) {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        subjectNode.fieldNames().forEachRemaining(configKey -> {
            try {
                service.applyConfig(subjectClassKey, subject, configKey, subjectNode.path(configKey));
            }
            catch (IllegalArgumentException e) {
                errorMsgs.add("Error parsing config " + subjectClassKey + "/" + subject + "/" + configKey);
            }
            catch (InvalidConfigException exception) {
                errorMsgs.add(exception.getMessage());
            }
        });
        return errorMsgs;
    }

    private ObjectNode produceErrorJson(List<String> errorMsgs) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode result = mapper.createObjectNode().put("code", 207).putPOJO("message", errorMsgs);
        return result;
    }

    @DELETE
    public Response delete() {
        NetworkConfigService service = (NetworkConfigService)this.get(NetworkConfigService.class);
        service.removeConfig();
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{subjectClassKey}")
    public Response delete(@PathParam(value="subjectClassKey") String subjectClassKey) {
        NetworkConfigService service = (NetworkConfigService)this.get(NetworkConfigService.class);
        SubjectFactory subjectFactory = (SubjectFactory)Tools.nullIsNotFound((Object)service.getSubjectFactory(subjectClassKey), (String)this.subjectClassNotValidErrorString(subjectClassKey));
        service.getSubjects(subjectFactory.subjectClass()).forEach(subject -> service.removeConfig(subject));
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{subjectClassKey}/{subjectKey}")
    public Response delete(@PathParam(value="subjectClassKey") String subjectClassKey, @PathParam(value="subjectKey") String subjectKey) {
        NetworkConfigService service = (NetworkConfigService)this.get(NetworkConfigService.class);
        SubjectFactory subjectFactory = (SubjectFactory)Tools.nullIsNotFound((Object)service.getSubjectFactory(subjectClassKey), (String)this.subjectClassNotValidErrorString(subjectClassKey));
        service.removeConfig(subjectFactory.createSubject(subjectKey));
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{subjectClassKey}/{subjectKey}/{configKey}")
    public Response delete(@PathParam(value="subjectClassKey") String subjectClassKey, @PathParam(value="subjectKey") String subjectKey, @PathParam(value="configKey") String configKey) {
        NetworkConfigService service = (NetworkConfigService)this.get(NetworkConfigService.class);
        SubjectFactory subjectFactory = (SubjectFactory)Tools.nullIsNotFound((Object)service.getSubjectFactory(subjectClassKey), (String)this.subjectClassNotValidErrorString(subjectClassKey));
        service.removeConfig(subjectClassKey, subjectFactory.createSubject(subjectKey), configKey);
        return Response.noContent().build();
    }
}

