/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onosproject.net.packet.PacketProcessorEntry;
import org.onosproject.net.packet.PacketService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="packet/processors")
public class PacketProcessorsWebResource
extends AbstractWebResource {
    @GET
    @Produces(value={"application/json"})
    public Response getPacketProcessors() {
        PacketService service = (PacketService)this.get(PacketService.class);
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode pktProcNode = root.putArray("packet-processors");
        List processors = service.getProcessors();
        ObjectMapper mapper = new ObjectMapper();
        for (PacketProcessorEntry p : processors) {
            pktProcNode.add((JsonNode)mapper.createObjectNode().put("priority", this.priorityFormat(p.priority())).put("class", p.processor().getClass().getName()).put("packets", p.invocations()).put("avgNanos", p.averageNanos()));
        }
        return PacketProcessorsWebResource.ok((Object)root).build();
    }

    private String priorityFormat(int priority) {
        if (priority > 0x55555554) {
            return "observer(" + (priority - 0x55555554 - 1) + ")";
        }
        if (priority > 0x2AAAAAAA) {
            return "director(" + (priority - 0x2AAAAAAA - 1) + ")";
        }
        return "advisor(" + (priority - 1) + ")";
    }
}

