/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.net.DeviceId;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionAdminService;
import org.onosproject.net.region.RegionId;
import org.onosproject.net.region.RegionService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="regions")
public class RegionsWebResource
extends AbstractWebResource {
    private final RegionService regionService = (RegionService)this.get(RegionService.class);
    private final RegionAdminService regionAdminService = (RegionAdminService)this.get(RegionAdminService.class);
    private static final String REGION_NOT_FOUND = "Region is not found for ";
    private static final String REGION_INVALID = "Invalid regionId in region update request";
    private static final String DEVICE_IDS_INVALID = "Invalid device identifiers";

    @GET
    @Produces(value={"application/json"})
    public Response getRegions() {
        Set regions = this.regionService.getRegions();
        return RegionsWebResource.ok((Object)this.encodeArray(Region.class, "regions", (Iterable)regions)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{regionId}")
    public Response getRegionById(@PathParam(value="regionId") String regionId) {
        RegionId rid = RegionId.regionId((String)regionId);
        Region region = (Region)Tools.nullIsNotFound((Object)this.regionService.getRegion(rid), (String)("Region is not found for " + rid.toString()));
        return RegionsWebResource.ok((Object)this.codec(Region.class).encode((Object)region, (CodecContext)this)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{regionId}/devices")
    public Response getRegionDevices(@PathParam(value="regionId") String regionId) {
        RegionId rid = RegionId.regionId((String)regionId);
        Set deviceIds = this.regionService.getRegionDevices(rid);
        ObjectNode root = this.mapper().createObjectNode();
        ArrayNode deviceIdsNode = root.putArray("deviceIds");
        deviceIds.forEach(did -> deviceIdsNode.add(did.toString()));
        return RegionsWebResource.ok((Object)root).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createRegion(InputStream stream) {
        URI location;
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            Region region = (Region)this.codec(Region.class).decode(jsonTree, (CodecContext)this);
            Region resultRegion = this.regionAdminService.createRegion(region.id(), region.name(), region.type(), region.masters());
            location = new URI((String)resultRegion.id().id());
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return Response.created((URI)location).build();
    }

    @PUT
    @Path(value="{regionId}")
    @Consumes(value={"application/json"})
    public Response updateRegion(@PathParam(value="regionId") String regionId, InputStream stream) {
        try {
            ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
            JsonNode specifiedRegionId = jsonTree.get("id");
            if (specifiedRegionId != null && !specifiedRegionId.asText().equals(regionId)) {
                throw new IllegalArgumentException("Invalid regionId in region update request");
            }
            Region region = (Region)this.codec(Region.class).decode(jsonTree, (CodecContext)this);
            this.regionAdminService.updateRegion(region.id(), region.name(), region.type(), region.masters());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{regionId}")
    public Response removeRegion(@PathParam(value="regionId") String regionId) {
        RegionId rid = RegionId.regionId((String)regionId);
        this.regionAdminService.removeRegion(rid);
        return Response.noContent().build();
    }

    @POST
    @Path(value="{regionId}/devices")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addDevices(@PathParam(value="regionId") String regionId, InputStream stream) {
        URI location;
        RegionId rid = RegionId.regionId((String)regionId);
        Region region = (Region)Tools.nullIsNotFound((Object)this.regionService.getRegion(rid), (String)("Region is not found for " + rid));
        try {
            this.regionAdminService.addDevices(region.id(), (Collection)this.extractDeviceIds(stream));
            location = new URI((String)rid.id());
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return Response.created((URI)location).build();
    }

    @DELETE
    @Path(value="{regionId}/devices")
    @Consumes(value={"application/json"})
    public Response removeDevices(@PathParam(value="regionId") String regionId, InputStream stream) {
        RegionId rid = RegionId.regionId((String)regionId);
        Region region = (Region)Tools.nullIsNotFound((Object)this.regionService.getRegion(rid), (String)("Region is not found for " + rid));
        try {
            this.regionAdminService.removeDevices(rid, (Collection)this.extractDeviceIds(stream));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return Response.noContent().build();
    }

    private Set<DeviceId> extractDeviceIds(InputStream stream) throws IOException {
        ObjectNode jsonTree = Tools.readTreeFromStream((ObjectMapper)this.mapper(), (InputStream)stream);
        JsonNode deviceIdsJson = jsonTree.get("deviceIds");
        if (deviceIdsJson == null || deviceIdsJson.size() == 0) {
            throw new IllegalArgumentException("Invalid device identifiers");
        }
        HashSet deviceIds = Sets.newHashSet();
        deviceIdsJson.forEach(did -> deviceIds.add(DeviceId.deviceId((String)did.asText())));
        return deviceIds;
    }
}

