/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest.resources;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterMetadataService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.core.CoreService;
import org.onosproject.core.Version;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="system")
public class SystemInfoWebResource
extends AbstractWebResource {
    private long activeNodes(Set<ControllerNode> nodes) {
        ClusterService clusterService = (ClusterService)this.get(ClusterService.class);
        return nodes.stream().map(node -> clusterService.getState(node.id())).filter(ControllerNode.State::isActive).count();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getSystemInfo() {
        IpAddress nodeIp = ((ClusterService)this.get(ClusterService.class)).getLocalNode().ip();
        Version version = ((CoreService)this.get(CoreService.class)).version();
        long numNodes = this.activeNodes(((ClusterService)this.get(ClusterService.class)).getNodes());
        int numDevices = ((DeviceService)this.get(DeviceService.class)).getDeviceCount();
        int numLinks = ((LinkService)this.get(LinkService.class)).getLinkCount();
        int numHosts = ((HostService)this.get(HostService.class)).getHostCount();
        int numScc = ((TopologyService)this.get(TopologyService.class)).currentTopology().clusterCount();
        int numFlows = ((FlowRuleService)this.get(FlowRuleService.class)).getFlowRuleCount();
        long numIntents = ((IntentService)this.get(IntentService.class)).getIntentCount();
        String clusterId = ((ClusterMetadataService)this.get(ClusterMetadataService.class)).getClusterMetadata().getName();
        ObjectNode root = this.mapper().createObjectNode().put("node", nodeIp.toString()).put("version", version.toString()).put("clusterId", clusterId).put("nodes", numNodes).put("devices", numDevices).put("links", numLinks).put("hosts", numHosts).put("sccs", numScc).put("flows", numFlows).put("intents", numIntents);
        MemoryUsage mem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        this.newObject(root, "mem").put("current", mem.getUsed()).put("max", mem.getMax()).put("committed", mem.getCommitted());
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        this.newObject(root, "threads").put("live", threads.getThreadCount()).put("daemon", threads.getDaemonThreadCount()).put("peak", threads.getPeakThreadCount());
        return SystemInfoWebResource.ok((Object)root).build();
    }
}

