/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.yang.compiler.datamodel.CollisionDetector;
import org.onosproject.yang.compiler.datamodel.SchemaDataNode;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangAugmentableNode;
import org.onosproject.yang.compiler.datamodel.YangCommonInfo;
import org.onosproject.yang.compiler.datamodel.YangConfig;
import org.onosproject.yang.compiler.datamodel.YangIfFeature;
import org.onosproject.yang.compiler.datamodel.YangIfFeatureHolder;
import org.onosproject.yang.compiler.datamodel.YangIsFilterContentNodes;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangMust;
import org.onosproject.yang.compiler.datamodel.YangMustHolder;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNodeType;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeType;
import org.onosproject.yang.compiler.datamodel.YangStatusType;
import org.onosproject.yang.compiler.datamodel.YangWhen;
import org.onosproject.yang.compiler.datamodel.YangWhenHolder;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.model.SingleInstanceNodeContext;

public abstract class YangContainer
extends YangNode
implements YangLeavesHolder,
YangCommonInfo,
Parsable,
CollisionDetector,
YangAugmentableNode,
YangMustHolder,
YangWhenHolder,
YangIfFeatureHolder,
YangIsFilterContentNodes,
YangConfig,
SingleInstanceNodeContext,
SchemaDataNode {
    private static final long serialVersionUID = 806201605L;
    private boolean isConfig;
    private String description;
    private List<YangLeaf> listOfLeaf;
    private List<YangLeafList> listOfLeafList;
    private String presence;
    private String reference;
    private List<YangAugment> yangAugmentedInfo = new ArrayList<YangAugment>();
    private YangStatusType status = YangStatusType.CURRENT;
    private List<YangMust> mustConstraintList;
    private YangWhen when;
    private List<YangIfFeature> ifFeatureList;

    public YangContainer() {
        super(YangNodeType.CONTAINER_NODE, new HashMap<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo>(), DataNode.Type.SINGLE_INSTANCE_NODE);
        this.listOfLeaf = new LinkedList<YangLeaf>();
        this.listOfLeafList = new LinkedList<YangLeafList>();
        this.mustConstraintList = new LinkedList<YangMust>();
        this.ifFeatureList = new LinkedList<YangIfFeature>();
    }

    @Override
    public void addToChildSchemaMap(YangSchemaNodeIdentifier schemaNodeIdentifier, YangSchemaNodeContextInfo yangSchemaNodeContextInfo) {
        this.getYsnContextInfoMap().put(schemaNodeIdentifier, yangSchemaNodeContextInfo);
    }

    @Override
    public void incrementMandatoryChildCount() {
    }

    @Override
    public void addToDefaultChildMap(YangSchemaNodeIdentifier yangSchemaNodeIdentifier, YangSchemaNode yangSchemaNode) {
    }

    @Override
    public YangSchemaNodeType getYangSchemaNodeType() {
        return YangSchemaNodeType.YANG_SINGLE_INSTANCE_NODE;
    }

    @Override
    public YangWhen getWhen() {
        return this.when;
    }

    @Override
    public void setWhen(YangWhen when) {
        this.when = when;
    }

    @Override
    public boolean isConfig() {
        return this.isConfig;
    }

    @Override
    public void setConfig(boolean isConfig) {
        this.isConfig = isConfig;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<YangLeaf> getListOfLeaf() {
        return this.listOfLeaf;
    }

    @Override
    public void setListOfLeaf(List<YangLeaf> leafsList) {
        this.listOfLeaf = leafsList;
    }

    @Override
    public void addLeaf(YangLeaf leaf) {
        this.listOfLeaf.add(leaf);
    }

    @Override
    public void removeLeaf(YangLeaf leaf) {
        this.listOfLeaf.remove(leaf);
    }

    @Override
    public List<YangLeafList> getListOfLeafList() {
        return this.listOfLeafList;
    }

    @Override
    public void setListOfLeafList(List<YangLeafList> listOfLeafList) {
        this.listOfLeafList = listOfLeafList;
    }

    @Override
    public void addLeafList(YangLeafList leafList) {
        this.listOfLeafList.add(leafList);
    }

    @Override
    public void removeLeafList(YangLeafList leafList) {
        this.listOfLeafList.remove(leafList);
    }

    public String getPresence() {
        return this.presence;
    }

    public void setPresence(String presence) {
        this.presence = presence;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public YangStatusType getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(YangStatusType status) {
        this.status = status;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.CONTAINER_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
        List<YangLeaf> leaves = this.getListOfLeaf();
        List<YangLeafList> leafLists = this.getListOfLeafList();
        this.validateConfig(leaves, leafLists);
    }

    private void validateConfig(List<YangLeaf> leaves, List<YangLeafList> leafLists) throws DataModelException {
        if (!this.isConfig && leaves != null) {
            for (YangLeaf leaf : leaves) {
                if (!leaf.isConfig()) continue;
                throw new DataModelException("If a container has \"config\" set to \"false\", no node underneath it can have \"config\" set to \"true\"." + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
            }
        }
        if (!this.isConfig && leafLists != null) {
            for (YangLeafList leafList : leafLists) {
                if (!leafList.isConfig()) continue;
                throw new DataModelException("If a container has \"config\" set to \"false\", no node underneath it can have \"config\" set to \"true\"." + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
            }
        }
    }

    @Override
    public void detectCollidingChild(String identifierName, YangConstructType dataType) throws DataModelException {
        DataModelUtils.detectCollidingChildUtil(identifierName, dataType, this);
    }

    @Override
    public void detectSelfCollision(String identifierName, YangConstructType dataType) throws DataModelException {
        if (this.getName().equals(identifierName)) {
            throw new DataModelException("YANG file error: Duplicate input identifier detected, same as container \"" + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
    }

    @Override
    public List<YangIfFeature> getIfFeatureList() {
        return this.ifFeatureList;
    }

    @Override
    public void addIfFeatureList(YangIfFeature ifFeature) {
        if (this.getIfFeatureList() == null) {
            this.setIfFeatureList(new LinkedList<YangIfFeature>());
        }
        this.getIfFeatureList().add(ifFeature);
    }

    @Override
    public void setIfFeatureList(List<YangIfFeature> ifFeatureList) {
        this.ifFeatureList = ifFeatureList;
    }

    @Override
    public List<YangMust> getListOfMust() {
        return this.mustConstraintList;
    }

    @Override
    public void setListOfMust(List<YangMust> mustConstraintList) {
        this.mustConstraintList = mustConstraintList;
    }

    @Override
    public void addMust(YangMust must) {
        if (this.getListOfMust() == null) {
            this.setListOfMust(new LinkedList<YangMust>());
        }
        this.getListOfMust().add(must);
    }

    @Override
    public void addAugmentation(YangAugment augmentInfo) {
        this.yangAugmentedInfo.add(augmentInfo);
    }

    @Override
    public void removeAugmentation(YangAugment augmentInfo) {
        this.yangAugmentedInfo.remove(augmentInfo);
    }

    @Override
    public List<YangAugment> getAugmentedInfoList() {
        return this.yangAugmentedInfo;
    }

    @Override
    public void setLeafNameSpaceAndAddToParentSchemaMap() {
        for (YangLeaf yangLeaf : this.getListOfLeaf()) {
            yangLeaf.setLeafNameSpaceAndAddToParentSchemaMap(this.getNameSpace());
        }
        for (YangLeafList yangLeafList : this.getListOfLeafList()) {
            yangLeafList.setLeafNameSpaceAndAddToParentSchemaMap(this.getNameSpace());
        }
    }

    @Override
    public void setLeafParentContext() {
        for (YangLeaf yangLeaf : this.getListOfLeaf()) {
            yangLeaf.setParentContext(DataModelUtils.getParentSchemaContext(this));
        }
        for (YangLeafList yangLeafList : this.getListOfLeafList()) {
            yangLeafList.setParentContext(DataModelUtils.getParentSchemaContext(this));
        }
    }

    @Override
    public void cloneAugmentInfo() {
        this.yangAugmentedInfo = new ArrayList<YangAugment>();
    }

    @Override
    public SchemaContext getChildContext(SchemaId schemaId) {
        Preconditions.checkNotNull((Object)schemaId, (Object)"Schema id should not be null.");
        YangSchemaNodeIdentifier id = DataModelUtils.getNodeIdFromSchemaId(schemaId, this.getNameSpace().getModuleNamespace());
        try {
            YangSchemaNode node = this.getChildSchema(id).getSchemaNode();
            if (node instanceof SchemaDataNode) {
                return node;
            }
            throw new IllegalArgumentException(DataModelUtils.errorMsg("Requested %s is not child in %s.", schemaId.name(), this.getName()));
        }
        catch (DataModelException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

