/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.YangModule;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;

public class YangImport
extends DefaultLocationInfo
implements Parsable,
Serializable {
    private static final long serialVersionUID = 806201642L;
    private String name;
    private String prefixId;
    private Date revision;
    private YangNode importedNode;

    public String getModuleName() {
        return this.name;
    }

    public void setModuleName(String moduleName) {
        this.name = moduleName;
    }

    public String getPrefixId() {
        return this.prefixId;
    }

    public void setPrefixId(String prefixId) {
        this.prefixId = prefixId;
    }

    public Date getRevision() {
        return this.revision;
    }

    public void setRevision(Date rev) {
        this.revision = rev;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.IMPORT_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }

    public YangNode getImportedNode() {
        return this.importedNode;
    }

    public void setImportedNode(YangNode importedNode) {
        this.importedNode = importedNode;
    }

    public void addReferenceToImport(Set<YangNode> yangNodeSet) throws DataModelException {
        String importedModuleName = this.getModuleName();
        Date importedModuleRevision = this.getRevision();
        YangNode moduleNode = null;
        if (importedModuleRevision != null) {
            String importedModuleNameWithRevision = importedModuleName + "@" + importedModuleRevision;
            moduleNode = DataModelUtils.findReferredNode(yangNodeSet, importedModuleNameWithRevision);
        }
        if (moduleNode == null) {
            moduleNode = DataModelUtils.findReferredNode(yangNodeSet, importedModuleName);
        }
        if (moduleNode != null && moduleNode instanceof YangModule) {
            if (this.getRevision() == null) {
                this.setImportedNode(moduleNode);
                return;
            }
            if (moduleNode.getRevision() != null && moduleNode.getRevision().getRevDate().equals(importedModuleRevision)) {
                this.setImportedNode(moduleNode);
                return;
            }
        }
        DataModelException exception = new DataModelException("YANG file error : Imported module " + importedModuleName + " with revision " + importedModuleRevision + " is not found.");
        exception.setLine(this.getLineNumber());
        exception.setCharPosition(this.getCharPosition());
        exception.setFileName(this.getFileName());
        throw exception;
    }
}

