/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.yang.compiler.datamodel.CollisionDetector;
import org.onosproject.yang.compiler.datamodel.InvalidOpTypeHolder;
import org.onosproject.yang.compiler.datamodel.SchemaDataNode;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangAugmentableNode;
import org.onosproject.yang.compiler.datamodel.YangCommonInfo;
import org.onosproject.yang.compiler.datamodel.YangIfFeature;
import org.onosproject.yang.compiler.datamodel.YangIfFeatureHolder;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNodeType;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeType;
import org.onosproject.yang.compiler.datamodel.YangStatusType;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.exceptions.ErrorMessages;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.model.SingleInstanceNodeContext;

public abstract class YangNotification
extends YangNode
implements YangLeavesHolder,
YangCommonInfo,
Parsable,
CollisionDetector,
YangAugmentableNode,
YangIfFeatureHolder,
InvalidOpTypeHolder,
SingleInstanceNodeContext {
    private static final long serialVersionUID = 806201611L;
    private String description;
    private List<YangLeaf> listOfLeaf;
    private List<YangLeafList> listOfLeafList;
    private String reference;
    private YangStatusType status = YangStatusType.CURRENT;
    private List<YangIfFeature> ifFeatureList;
    private List<YangAugment> yangAugmentedInfo;

    public YangNotification() {
        super(YangNodeType.NOTIFICATION_NODE, new HashMap<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo>(), DataNode.Type.SINGLE_INSTANCE_NODE);
        this.listOfLeaf = new LinkedList<YangLeaf>();
        this.listOfLeafList = new LinkedList<YangLeafList>();
        this.ifFeatureList = new LinkedList<YangIfFeature>();
        this.yangAugmentedInfo = new LinkedList<YangAugment>();
    }

    @Override
    public void addToChildSchemaMap(YangSchemaNodeIdentifier id, YangSchemaNodeContextInfo context) throws DataModelException {
        this.getYsnContextInfoMap().put(id, context);
    }

    @Override
    public void incrementMandatoryChildCount() {
    }

    @Override
    public void addToDefaultChildMap(YangSchemaNodeIdentifier id, YangSchemaNode yangSchemaNode) {
    }

    @Override
    public YangSchemaNodeType getYangSchemaNodeType() {
        return YangSchemaNodeType.YANG_SINGLE_INSTANCE_NODE;
    }

    @Override
    public void detectCollidingChild(String identifierName, YangConstructType dataType) throws DataModelException {
        DataModelUtils.detectCollidingChildUtil(identifierName, dataType, this);
    }

    @Override
    public void detectSelfCollision(String identifierName, YangConstructType dataType) throws DataModelException {
        if (this.getName().equals(identifierName)) {
            throw new DataModelException(ErrorMessages.getErrorMsgCollision("YANG File Error: Identifier collision detected in", this.getName(), this.getLineNumber(), this.getCharPosition(), " notificaiton ", this.getFileName()));
        }
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.NOTIFICATION_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<YangLeaf> getListOfLeaf() {
        return Collections.unmodifiableList(this.listOfLeaf);
    }

    @Override
    public void setListOfLeaf(List<YangLeaf> leafsList) {
        this.listOfLeaf = leafsList;
    }

    @Override
    public void addLeaf(YangLeaf leaf) {
        this.listOfLeaf.add(leaf);
    }

    @Override
    public void removeLeaf(YangLeaf leaf) {
        this.listOfLeaf.remove(leaf);
    }

    @Override
    public List<YangLeafList> getListOfLeafList() {
        return Collections.unmodifiableList(this.listOfLeafList);
    }

    @Override
    public void setListOfLeafList(List<YangLeafList> listOfLeafList) {
        this.listOfLeafList = listOfLeafList;
    }

    @Override
    public void addLeafList(YangLeafList leafList) {
        this.listOfLeafList.add(leafList);
    }

    @Override
    public void removeLeafList(YangLeafList leafList) {
        this.listOfLeafList.remove(leafList);
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public YangStatusType getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(YangStatusType status) {
        this.status = status;
    }

    @Override
    public List<YangIfFeature> getIfFeatureList() {
        return Collections.unmodifiableList(this.ifFeatureList);
    }

    @Override
    public void addIfFeatureList(YangIfFeature ifFeature) {
        this.ifFeatureList.add(ifFeature);
    }

    @Override
    public void setIfFeatureList(List<YangIfFeature> ifFeatureList) {
        this.ifFeatureList = ifFeatureList;
    }

    @Override
    public void addAugmentation(YangAugment augmentInfo) {
        this.yangAugmentedInfo.add(augmentInfo);
    }

    @Override
    public void removeAugmentation(YangAugment augmentInfo) {
        this.yangAugmentedInfo.remove(augmentInfo);
    }

    @Override
    public List<YangAugment> getAugmentedInfoList() {
        return Collections.unmodifiableList(this.yangAugmentedInfo);
    }

    @Override
    public void setLeafNameSpaceAndAddToParentSchemaMap() {
        for (YangLeaf yangLeaf : this.listOfLeaf) {
            yangLeaf.setLeafNameSpaceAndAddToParentSchemaMap(this.getNameSpace());
        }
        for (YangLeafList yangLeafList : this.listOfLeafList) {
            yangLeafList.setLeafNameSpaceAndAddToParentSchemaMap(this.getNameSpace());
        }
    }

    @Override
    public void setLeafParentContext() {
        for (YangLeaf yangLeaf : this.getListOfLeaf()) {
            yangLeaf.setParentContext(DataModelUtils.getParentSchemaContext(this));
        }
        for (YangLeafList yangLeafList : this.getListOfLeafList()) {
            yangLeafList.setParentContext(DataModelUtils.getParentSchemaContext(this));
        }
    }

    @Override
    public void cloneAugmentInfo() {
        this.yangAugmentedInfo = new ArrayList<YangAugment>();
    }

    @Override
    public SchemaContext getChildContext(SchemaId schemaId) {
        Preconditions.checkNotNull((Object)schemaId, (Object)"Schema id should not be null.");
        YangSchemaNodeIdentifier id = DataModelUtils.getNodeIdFromSchemaId(schemaId, this.getNameSpace().getModuleNamespace());
        try {
            YangSchemaNode node = this.getChildSchema(id).getSchemaNode();
            if (node instanceof SchemaDataNode) {
                return node;
            }
            throw new IllegalArgumentException(DataModelUtils.errorMsg("Requested %s is not child in %s.", schemaId.name(), this.getName()));
        }
        catch (DataModelException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

