/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.onosproject.yang.compiler.datamodel.CollisionDetector;
import org.onosproject.yang.compiler.datamodel.DefaultYangNamespace;
import org.onosproject.yang.compiler.datamodel.ResolvableType;
import org.onosproject.yang.compiler.datamodel.SchemaDataNode;
import org.onosproject.yang.compiler.datamodel.YangAtomicPath;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangBase;
import org.onosproject.yang.compiler.datamodel.YangCompilerAnnotation;
import org.onosproject.yang.compiler.datamodel.YangConfig;
import org.onosproject.yang.compiler.datamodel.YangDefault;
import org.onosproject.yang.compiler.datamodel.YangDerivedInfo;
import org.onosproject.yang.compiler.datamodel.YangDeviateAdd;
import org.onosproject.yang.compiler.datamodel.YangDeviateDelete;
import org.onosproject.yang.compiler.datamodel.YangDeviateReplace;
import org.onosproject.yang.compiler.datamodel.YangDeviation;
import org.onosproject.yang.compiler.datamodel.YangEntityToResolveInfo;
import org.onosproject.yang.compiler.datamodel.YangEntityToResolveInfoImpl;
import org.onosproject.yang.compiler.datamodel.YangEnumeration;
import org.onosproject.yang.compiler.datamodel.YangIdentityRef;
import org.onosproject.yang.compiler.datamodel.YangIfFeature;
import org.onosproject.yang.compiler.datamodel.YangImport;
import org.onosproject.yang.compiler.datamodel.YangInput;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangMandatory;
import org.onosproject.yang.compiler.datamodel.YangMaxElementHolder;
import org.onosproject.yang.compiler.datamodel.YangMinElementHolder;
import org.onosproject.yang.compiler.datamodel.YangModule;
import org.onosproject.yang.compiler.datamodel.YangMust;
import org.onosproject.yang.compiler.datamodel.YangMustHolder;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNotification;
import org.onosproject.yang.compiler.datamodel.YangOutput;
import org.onosproject.yang.compiler.datamodel.YangReferenceResolver;
import org.onosproject.yang.compiler.datamodel.YangResolutionInfo;
import org.onosproject.yang.compiler.datamodel.YangRpc;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeType;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.YangUnion;
import org.onosproject.yang.compiler.datamodel.YangUniqueHolder;
import org.onosproject.yang.compiler.datamodel.YangUnits;
import org.onosproject.yang.compiler.datamodel.YangUses;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.model.LeafType;
import org.onosproject.yang.model.SchemaId;

public final class DataModelUtils {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final String SLASH = File.separator;
    public static final String FMT_NOT_EXIST = "Requested %s is not child in %s.";
    private static final String E_DATATYPE = "Data type not supported.";
    public static final String E_ID = "Schema id should not be null.";

    private DataModelUtils() {
    }

    public static void detectCollidingChildUtil(String identifierName, YangConstructType dataType, YangNode node) throws DataModelException {
        if (dataType == YangConstructType.USES_DATA || dataType == YangConstructType.GROUPING_DATA) {
            DataModelUtils.detectCollidingForUsesGrouping(identifierName, dataType, node);
        } else {
            if (node instanceof YangLeavesHolder) {
                YangLeavesHolder leavesHolder = (YangLeavesHolder)((Object)node);
                DataModelUtils.detectCollidingLeaf(leavesHolder.getListOfLeaf(), identifierName);
                DataModelUtils.detectCollidingLeafList(leavesHolder.getListOfLeafList(), identifierName);
            }
            for (node = node.getChild(); node != null; node = node.getNextSibling()) {
                Parsable parsable = (Parsable)((Object)node);
                if (!(node instanceof CollisionDetector) || parsable.getYangConstructType() == YangConstructType.USES_DATA || parsable.getYangConstructType() == YangConstructType.GROUPING_DATA) continue;
                ((CollisionDetector)((Object)node)).detectSelfCollision(identifierName, dataType);
            }
        }
    }

    private static void detectCollidingForUsesGrouping(String identifierName, YangConstructType dataType, YangNode node) throws DataModelException {
        for (node = node.getChild(); node != null; node = node.getNextSibling()) {
            Parsable parsable = (Parsable)((Object)node);
            if (!(node instanceof CollisionDetector) || parsable.getYangConstructType() != dataType) continue;
            ((CollisionDetector)((Object)node)).detectSelfCollision(identifierName, dataType);
        }
    }

    private static void detectCollidingLeaf(List<YangLeaf> listOfLeaf, String identifierName) throws DataModelException {
        if (listOfLeaf == null) {
            return;
        }
        for (YangLeaf leaf : listOfLeaf) {
            if (!leaf.getName().equals(identifierName)) continue;
            throw new DataModelException("YANG file error: Duplicate input identifier detected, same as leaf \"" + leaf.getName() + " in " + leaf.getLineNumber() + " at " + leaf.getCharPosition() + " in " + leaf.getFileName() + "\"");
        }
    }

    private static void detectCollidingLeafList(List<YangLeafList> listOfLeafList, String identifierName) throws DataModelException {
        if (listOfLeafList == null) {
            return;
        }
        for (YangLeafList leafList : listOfLeafList) {
            if (!leafList.getName().equals(identifierName)) continue;
            throw new DataModelException("YANG file error: Duplicate input identifier detected, same as leaf list \"" + leafList.getName() + " in " + leafList.getLineNumber() + " at " + leafList.getCharPosition() + " in " + leafList.getFileName() + "\"");
        }
    }

    public static void addResolutionInfo(YangResolutionInfo resolutionInfo) throws DataModelException {
        YangNode curNode = resolutionInfo.getEntityToResolveInfo().getHolderOfEntityToResolve();
        while (!(curNode instanceof YangReferenceResolver)) {
            if ((curNode = curNode.getParent()) != null) continue;
            throw new DataModelException("Internal datamodel error: Datamodel tree is not correct");
        }
        YangReferenceResolver resolutionNode = (YangReferenceResolver)((Object)curNode);
        YangEntityToResolveInfo entityToResolveInfo = resolutionInfo.getEntityToResolveInfo();
        if (entityToResolveInfo.getEntityToResolve() instanceof YangType) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_DERIVED_DATA_TYPE);
        } else if (entityToResolveInfo.getEntityToResolve() instanceof YangUses) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_USES);
        } else if (entityToResolveInfo.getEntityToResolve() instanceof YangAugment) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_AUGMENT);
        } else if (entityToResolveInfo.getEntityToResolve() instanceof YangIfFeature) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_IF_FEATURE);
        } else if (entityToResolveInfo.getEntityToResolve() instanceof YangLeafRef) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_LEAFREF);
        } else if (entityToResolveInfo.getEntityToResolve() instanceof YangBase) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_BASE);
        } else if (entityToResolveInfo.getEntityToResolve() instanceof YangIdentityRef) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_IDENTITYREF);
        } else if (entityToResolveInfo.getEntityToResolve() instanceof YangCompilerAnnotation) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_COMPILER_ANNOTATION);
        } else if (entityToResolveInfo.getEntityToResolve() instanceof YangDeviation) {
            resolutionNode.addToResolutionList(resolutionInfo, ResolvableType.YANG_DEVIATION);
        }
    }

    public static void resolveLinkingForResolutionList(List<YangResolutionInfo> resolutionList, YangReferenceResolver dataModelRootNode) throws DataModelException {
        for (YangResolutionInfo resolutionInfo : resolutionList) {
            resolutionInfo.resolveLinkingForResolutionInfo(dataModelRootNode);
        }
    }

    public static void linkInterFileReferences(List<YangResolutionInfo> resolutionList, YangReferenceResolver dataModelRootNode) throws DataModelException {
        if (resolutionList != null) {
            for (YangResolutionInfo resolutionInfo : resolutionList) {
                resolutionInfo.linkInterFile(dataModelRootNode);
            }
        }
    }

    public static boolean isRpcChildNodePresent(YangNode rootNode) {
        for (YangNode childNode = rootNode.getChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (!(childNode instanceof YangRpc)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRpcNotificationPresent(YangNode rootNode) {
        for (YangNode childNode = rootNode.getChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (!(childNode instanceof YangRpc) && !(childNode instanceof YangNotification)) continue;
            return true;
        }
        return false;
    }

    public static YangNode findReferredNode(Set<YangNode> yangNodeSet, String refNodeName) {
        for (YangNode yangNode : yangNodeSet) {
            if (!yangNode.getName().equals(refNodeName)) continue;
            return yangNode;
        }
        return null;
    }

    public static YangNode getParentNodeInGenCode(YangNode currentNode) {
        return currentNode.getParent();
    }

    public static Set<YangNode> deSerializeDataModel(String serializedFileInfo) throws IOException {
        Set nodes;
        try {
            FileInputStream fileInputStream = new FileInputStream(serializedFileInfo);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            nodes = (Set)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IOException(serializedFileInfo + " not found.");
        }
        return nodes;
    }

    public static void cloneListOfLeaf(YangLeavesHolder clonedNode, YangUses yangUses, boolean isDeviation) throws CloneNotSupportedException, DataModelException {
        List<YangLeaf> leaves = clonedNode.getListOfLeaf();
        if (DataModelUtils.nonEmpty(leaves)) {
            LinkedList<YangLeaf> clonedLeaves = new LinkedList<YangLeaf>();
            for (YangLeaf leaf : leaves) {
                YangLeaf clonedLeaf;
                if (!isDeviation) {
                    clonedLeaf = leaf.clone();
                    DataModelUtils.addUnresolvedType(yangUses, clonedLeaf, (YangNode)((Object)clonedNode));
                } else {
                    clonedLeaf = leaf.cloneForDeviation();
                }
                clonedLeaf.setReferredLeaf(leaf);
                clonedLeaf.setContainedIn(clonedNode);
                clonedLeaves.add(clonedLeaf);
            }
            clonedNode.setListOfLeaf(clonedLeaves);
        }
    }

    public static void addUnresolvedType(YangUses yangUses, Object clonedObj, YangNode clonedNode) throws DataModelException {
        List<YangEntityToResolveInfoImpl> infoList;
        if (yangUses != null && yangUses.getCurrentGroupingDepth() == 0 && DataModelUtils.nonEmpty(infoList = DataModelUtils.getTypesToBeResolved(clonedObj, clonedNode, yangUses))) {
            yangUses.addEntityToResolve(infoList);
        }
    }

    public static boolean nonEmpty(Collection<?> c) {
        return c != null && !c.isEmpty();
    }

    public static void cloneListOfLeafList(YangLeavesHolder clonedNode, YangUses yangUses, boolean isDeviation) throws CloneNotSupportedException, DataModelException {
        List<YangLeafList> listOfLeafList = clonedNode.getListOfLeafList();
        if (DataModelUtils.nonEmpty(listOfLeafList)) {
            LinkedList<YangLeafList> clonedList = new LinkedList<YangLeafList>();
            for (YangLeafList leafList : listOfLeafList) {
                YangLeafList clonedLeafList;
                if (!isDeviation) {
                    clonedLeafList = leafList.clone();
                    DataModelUtils.addUnresolvedType(yangUses, clonedLeafList, (YangNode)((Object)clonedNode));
                } else {
                    clonedLeafList = leafList.cloneForDeviation();
                }
                clonedLeafList.setReferredSchemaLeafList(leafList);
                clonedLeafList.setContainedIn(clonedNode);
                clonedList.add(clonedLeafList);
            }
            clonedNode.setListOfLeafList(clonedList);
        }
    }

    private static List<YangEntityToResolveInfoImpl> getTypesToBeResolved(Object clonedObj, YangNode holderNode, YangUses yangUses) throws DataModelException {
        if (clonedObj instanceof YangLeaf) {
            YangLeaf clonedLeaf = (YangLeaf)clonedObj;
            YangType<?> type = clonedLeaf.getDataType();
            return DataModelUtils.getUnresolvedTypeList(type.getDataType(), type, holderNode, yangUses, true);
        }
        YangLeafList clonedLeafList = (YangLeafList)clonedObj;
        YangType<?> type = clonedLeafList.getDataType();
        return DataModelUtils.getUnresolvedTypeList(type.getDataType(), type, holderNode, yangUses, false);
    }

    private static List<YangEntityToResolveInfoImpl> getUnresolvedTypeList(YangDataTypes dataTypes, YangType type, YangNode holder, YangUses yangUses, boolean isLeaf) throws DataModelException {
        ArrayList<YangEntityToResolveInfoImpl> infoList = new ArrayList<YangEntityToResolveInfoImpl>();
        YangEntityToResolveInfoImpl entity = null;
        List<YangEntityToResolveInfoImpl> entityList = null;
        switch (dataTypes) {
            case LEAFREF: {
                entity = DataModelUtils.getLeafRefResolvableEntity(type, yangUses, holder);
                break;
            }
            case DERIVED: {
                entity = DataModelUtils.getDerivedResolvableEntity(type, holder, isLeaf);
                break;
            }
            case UNION: {
                entityList = DataModelUtils.getUnionResolvableEntity(type, isLeaf);
                break;
            }
            default: {
                return null;
            }
        }
        infoList.add(entity);
        if (DataModelUtils.nonEmpty(entityList)) {
            infoList.addAll(entityList);
        }
        return infoList;
    }

    private static YangEntityToResolveInfoImpl getLeafRefResolvableEntity(YangType type, YangUses yangUses, YangNode holder) throws DataModelException {
        YangEntityToResolveInfoImpl<YangLeafRef> leafRefInfo = new YangEntityToResolveInfoImpl<YangLeafRef>();
        YangLeafRef leafRef = (YangLeafRef)type.getDataTypeExtendedInfo();
        DataModelUtils.convertThePrefixesDuringChange(leafRef, yangUses);
        leafRef.setParentNode(holder);
        leafRefInfo.setEntityToResolve(leafRef);
        return DataModelUtils.setInformationInEntity(leafRefInfo, holder, leafRef.getCharPosition(), leafRef.getLineNumber());
    }

    private static YangEntityToResolveInfoImpl getDerivedResolvableEntity(YangType<?> type, YangNode holder, boolean isLeaf) {
        YangEntityToResolveInfoImpl derivedInfo = new YangEntityToResolveInfoImpl();
        if (type.isTypeForInterFileGroupingResolution()) {
            return null;
        }
        if (!isLeaf && type.isTypeNotResolvedTillRootNode()) {
            return null;
        }
        derivedInfo.setEntityToResolve(type);
        return DataModelUtils.setInformationInEntity(derivedInfo, holder, type.getCharPosition(), type.getLineNumber());
    }

    private static YangEntityToResolveInfoImpl<?> setInformationInEntity(YangEntityToResolveInfoImpl<?> entity, YangNode holder, int charPos, int lineNum) {
        entity.setHolderOfEntityToResolve(holder);
        entity.setCharPosition(charPos);
        entity.setLineNumber(lineNum);
        return entity;
    }

    private static List<YangEntityToResolveInfoImpl> getUnionResolvableEntity(YangType type, boolean isLeaf) throws DataModelException {
        YangUnion union = (YangUnion)type.getDataTypeExtendedInfo();
        List<YangType<?>> typeList = union.getTypeList();
        ArrayList<YangEntityToResolveInfoImpl> unionList = new ArrayList<YangEntityToResolveInfoImpl>();
        for (YangType<?> unionType : typeList) {
            List<YangEntityToResolveInfoImpl> entity = DataModelUtils.getUnresolvedTypeList(unionType.getDataType(), unionType, union, null, isLeaf);
            if (!DataModelUtils.nonEmpty(entity)) continue;
            unionList.addAll(entity);
        }
        return unionList;
    }

    private static void convertThePrefixesDuringChange(YangLeafRef leafrefForCloning, YangUses yangUses) throws DataModelException {
        List<YangAtomicPath> atomicPathList = leafrefForCloning.getAtomicPath();
        if (atomicPathList != null && !atomicPathList.isEmpty()) {
            ListIterator<YangAtomicPath> atomicPathIterator = atomicPathList.listIterator();
            while (atomicPathIterator.hasNext()) {
                YangAtomicPath atomicPath = (YangAtomicPath)atomicPathIterator.next();
                Map<String, String> prefixesAndItsImportNameNode = leafrefForCloning.getPrefixAndNode();
                String prefixInPath = atomicPath.getNodeIdentifier().getPrefix();
                String importedNodeName = prefixesAndItsImportNameNode.get(prefixInPath);
                DataModelUtils.assignCurrentLeafedWithNewPrefixes(importedNodeName, atomicPath, yangUses);
            }
        }
    }

    private static void assignCurrentLeafedWithNewPrefixes(String importedNodeName, YangAtomicPath atomicPath, YangNode node) throws DataModelException {
        List<YangImport> importInUsesList;
        while (!(node instanceof YangReferenceResolver)) {
            if ((node = node.getParent()) != null) continue;
            throw new DataModelException("Internal datamodel error: Datamodel tree is not correct");
        }
        if (node instanceof YangModule && (importInUsesList = ((YangModule)node).getImportList()) != null && !importInUsesList.isEmpty()) {
            ListIterator<YangImport> importInUsesListIterator = importInUsesList.listIterator();
            while (importInUsesListIterator.hasNext()) {
                YangImport importInUsesNode = (YangImport)importInUsesListIterator.next();
                if (!importInUsesNode.getModuleName().equals(importedNodeName)) continue;
                atomicPath.getNodeIdentifier().setPrefix(importInUsesNode.getPrefixId());
            }
        }
    }

    public static void updateClonedLeavesUnionEnumRef(YangLeavesHolder leavesHolder) throws DataModelException {
        List<YangLeafList> currentListOfLeafList;
        List<YangLeaf> currentListOfLeaves = leavesHolder.getListOfLeaf();
        if (currentListOfLeaves != null) {
            for (YangLeaf leaf : currentListOfLeaves) {
                if (leaf.getDataType().getDataType() != YangDataTypes.ENUMERATION && leaf.getDataType().getDataType() != YangDataTypes.UNION) continue;
                try {
                    Object clonedType = leaf.getDataType().clone();
                    DataModelUtils.updateClonedTypeRef((YangType)clonedType, leavesHolder);
                    leaf.setDataType((YangType<?>)clonedType);
                }
                catch (DataModelException e) {
                    throw e;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                    throw new DataModelException("Could not clone Type node " + leaf.getDataType().getDataTypeName() + " in " + leaf.getDataType().getLineNumber() + " at " + leaf.getDataType().getCharPosition() + " in " + leaf.getDataType().getFileName() + "\"");
                }
            }
        }
        if ((currentListOfLeafList = leavesHolder.getListOfLeafList()) != null) {
            for (YangLeafList leafList : currentListOfLeafList) {
                if (leafList.getDataType().getDataType() != YangDataTypes.ENUMERATION && leafList.getDataType().getDataType() != YangDataTypes.UNION) continue;
                try {
                    Object clonedType = leafList.getDataType().clone();
                    DataModelUtils.updateClonedTypeRef((YangType)clonedType, leavesHolder);
                    leafList.setDataType((YangType<?>)clonedType);
                }
                catch (DataModelException e) {
                    throw e;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                    throw new DataModelException("Could not clone Type node " + leafList.getDataType().getDataTypeName() + " in " + leafList.getDataType().getLineNumber() + " at " + leafList.getDataType().getCharPosition() + " in " + leafList.getDataType().getFileName() + "\"");
                }
            }
        }
    }

    private static void updateClonedTypeRef(YangType dataType, YangLeavesHolder leavesHolder) throws DataModelException {
        if (!(leavesHolder instanceof YangNode)) {
            throw new DataModelException("Data model error: cloned leaves holder is not a node  in " + leavesHolder.getLineNumber() + " at " + leavesHolder.getCharPosition() + " in " + leavesHolder.getFileName() + "\"");
        }
        for (YangNode potentialTypeNode = ((YangNode)((Object)leavesHolder)).getChild(); potentialTypeNode != null; potentialTypeNode = potentialTypeNode.getNextSibling()) {
            String dataTypeName = null;
            if (dataType.getDataType() == YangDataTypes.ENUMERATION) {
                YangEnumeration enumNode = (YangEnumeration)dataType.getDataTypeExtendedInfo();
                dataTypeName = enumNode.getName();
            } else if (dataType.getDataType() == YangDataTypes.UNION) {
                YangUnion unionNode = (YangUnion)dataType.getDataTypeExtendedInfo();
                dataTypeName = unionNode.getName();
            }
            if (!potentialTypeNode.getName().contentEquals(dataTypeName)) continue;
            dataType.setDataTypeExtendedInfo(potentialTypeNode);
            return;
        }
        throw new DataModelException("Data model error: cloned leaves type is not found " + dataType.getDataTypeName() + " in " + dataType.getLineNumber() + " at " + dataType.getCharPosition() + " in " + dataType.getFileName() + "\"");
    }

    public static List<YangNode> parseJarFile(String jarFile, String directory) throws IOException {
        ArrayList<YangNode> nodes = new ArrayList<YangNode>();
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry file = enumEntries.nextElement();
            if (!file.getName().endsWith(".ser")) continue;
            if (file.getName().contains(SLASH)) {
                String[] strArray = file.getName().split(SLASH);
                String tempPath = "";
                for (int i = 0; i < strArray.length - 1; ++i) {
                    tempPath = SLASH + tempPath + SLASH + strArray[i];
                }
                File dir = new File(directory + tempPath);
                dir.mkdirs();
            }
            File serializedFile = new File(directory + SLASH + file.getName());
            if (file.isDirectory()) {
                serializedFile.mkdirs();
                continue;
            }
            InputStream inputStream = jar.getInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(serializedFile);
            while (inputStream.available() > 0) {
                fileOutputStream.write(inputStream.read());
            }
            fileOutputStream.close();
            inputStream.close();
            nodes.addAll(DataModelUtils.deSerializeDataModel(serializedFile.toString()));
            break;
        }
        jar.close();
        return nodes;
    }

    public static File parseDepSchemaPath(String jarFile, String directory) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enumEntries = jar.entries();
        File serializedFile = null;
        while (enumEntries.hasMoreElements()) {
            JarEntry file = enumEntries.nextElement();
            if (!file.getName().endsWith(".ser")) continue;
            if (file.getName().contains(SLASH)) {
                String[] strArray = file.getName().split(SLASH);
                String tempPath = "";
                for (int i = 0; i < strArray.length - 1; ++i) {
                    tempPath = SLASH + tempPath + SLASH + strArray[i];
                }
                File dir = new File(directory + tempPath);
                dir.mkdirs();
            }
            serializedFile = new File(directory + SLASH + file.getName());
            if (file.isDirectory()) {
                serializedFile.mkdirs();
                continue;
            }
            InputStream inputStream = jar.getInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(serializedFile);
            while (inputStream.available() > 0) {
                fileOutputStream.write(inputStream.read());
            }
            fileOutputStream.close();
            inputStream.close();
            break;
        }
        jar.close();
        return serializedFile;
    }

    public static boolean validateEmptyDataType(YangType dataType) {
        switch (dataType.getDataType()) {
            case DERIVED: {
                return ((YangDerivedInfo)dataType.getDataTypeExtendedInfo()).getEffectiveBuiltInType().equals((Object)YangDataTypes.EMPTY);
            }
            case LEAFREF: {
                YangType type = ((YangLeafRef)dataType.getDataTypeExtendedInfo()).getEffectiveDataType();
                if (type.getDataType() == YangDataTypes.DERIVED) {
                    return ((YangDerivedInfo)type.getDataTypeExtendedInfo()).getEffectiveBuiltInType().equals((Object)YangDataTypes.EMPTY);
                }
                return ((YangLeafRef)dataType.getDataTypeExtendedInfo()).getEffectiveDataType().getDataType().equals((Object)YangDataTypes.EMPTY);
            }
            case UNION: {
                return ((YangUnion)dataType.getDataTypeExtendedInfo()).getTypeList().contains((Object)YangDataTypes.EMPTY);
            }
        }
        return dataType.getDataType().equals((Object)YangDataTypes.EMPTY);
    }

    public static void validateMultipleDeviationStatement(YangReferenceResolver node) throws DataModelException {
        List<YangResolutionInfo> deviationList = node.getUnresolvedResolutionList(ResolvableType.YANG_DEVIATION);
        String prefix = null;
        if (!deviationList.isEmpty()) {
            YangDeviation firstDeviation = (YangDeviation)deviationList.get(0).getEntityToResolveInfo().getEntityToResolve();
            YangAtomicPath atomic = firstDeviation.getTargetNode().get(0);
            prefix = atomic.getNodeIdentifier().getPrefix();
        }
        Iterator<YangResolutionInfo> deviationIterator = deviationList.iterator();
        while (deviationIterator.hasNext()) {
            YangDeviation deviation = (YangDeviation)deviationIterator.next().getEntityToResolveInfo().getEntityToResolve();
            List<YangAtomicPath> targetNode = deviation.getTargetNode();
            YangAtomicPath atomicPath = targetNode.get(0);
            if (atomicPath.getNodeIdentifier().getPrefix().equals(prefix)) continue;
            throw new DataModelException("YANG FILE ERROR : Deviations of multiple module is currently not supported.");
        }
    }

    public static void deleteUnsupportedNodeFromTree(YangNode node) {
        YangNode parentNode = node.getParent();
        if (parentNode.getChild().equals(node)) {
            parentNode.setChild(node.getNextSibling());
        }
        YangNode previousSibling = node.getPreviousSibling();
        YangNode nextSibling = node.getNextSibling();
        if (nextSibling != null && previousSibling != null) {
            previousSibling.setNextSibling(nextSibling);
            nextSibling.setPreviousSibling(previousSibling);
        } else if (nextSibling != null) {
            nextSibling.setPreviousSibling(null);
        } else if (previousSibling != null) {
            previousSibling.setNextSibling(null);
        }
        node.setParent(null);
        node.setPreviousSibling(null);
        node.setNextSibling(null);
        node.setChild(null);
    }

    public static void deleteUnsupportedLeafOrLeafList(YangLeavesHolder node, String leafName) {
        List<YangLeafList> leafList;
        List<YangLeaf> leaves = node.getListOfLeaf();
        if (leaves != null && !leaves.isEmpty()) {
            for (YangLeaf leaf : leaves) {
                if (!leaf.getName().equals(leafName)) continue;
                node.removeLeaf(leaf);
                return;
            }
        }
        if ((leafList = node.getListOfLeafList()) != null && !leafList.isEmpty()) {
            for (YangLeafList leaf : leafList) {
                if (!leaf.getName().equals(leafName)) continue;
                node.removeLeafList(leaf);
                return;
            }
        }
    }

    public static void updateDeviateDeleteToTargetNode(YangSchemaNode targetNode, YangDeviateDelete deviateDelete) throws DataModelException {
        if (targetNode instanceof YangMustHolder && !deviateDelete.getListOfMust().isEmpty()) {
            deviateDelete.setListOfMust(new LinkedList<YangMust>());
        }
        if (targetNode instanceof YangUniqueHolder && !deviateDelete.getUniqueList().isEmpty()) {
            deviateDelete.setUniqueList(new LinkedList<String>());
        }
        if (targetNode instanceof YangUnits) {
            ((YangUnits)((Object)targetNode)).setUnits(null);
        }
        if (targetNode instanceof YangDefault) {
            ((YangDefault)((Object)targetNode)).setDefaultValueInString(null);
        }
    }

    public static void updateDeviateAddToTargetNode(YangSchemaNode targetNode, YangDeviateAdd deviateAdd) throws DataModelException {
        if (targetNode instanceof YangMustHolder && !deviateAdd.getListOfMust().isEmpty()) {
            ListIterator<YangMust> mustList = deviateAdd.getListOfMust().listIterator();
            while (mustList.hasNext()) {
                ((YangMustHolder)((Object)targetNode)).addMust((YangMust)mustList.next());
            }
        }
        if (targetNode instanceof YangUniqueHolder && !deviateAdd.getUniqueList().isEmpty()) {
            ListIterator<String> uniqueList = deviateAdd.getUniqueList().listIterator();
            while (uniqueList.hasNext()) {
                ((YangUniqueHolder)((Object)targetNode)).addUnique((String)uniqueList.next());
            }
        }
        if (targetNode instanceof YangConfig) {
            ((YangConfig)((Object)targetNode)).setConfig(deviateAdd.isConfig());
        }
        if (targetNode instanceof YangUnits) {
            ((YangUnits)((Object)targetNode)).setUnits(deviateAdd.getUnits());
        }
        if (targetNode instanceof YangDefault) {
            ((YangDefault)((Object)targetNode)).setDefaultValueInString(deviateAdd.getDefaultValueInString());
        }
        if (targetNode instanceof YangMandatory) {
            ((YangMandatory)((Object)targetNode)).setMandatory(deviateAdd.isMandatory());
        }
        if (targetNode instanceof YangMinElementHolder) {
            ((YangMinElementHolder)((Object)targetNode)).setMinElements(deviateAdd.getMinElements());
        }
        if (targetNode instanceof YangMaxElementHolder) {
            ((YangMaxElementHolder)((Object)targetNode)).setMaxElements(deviateAdd.getMaxElements());
        }
    }

    public static void updateDeviateReplaceToTargetNode(YangSchemaNode targetNode, YangDeviateReplace deviateReplace) {
        if (targetNode instanceof YangLeaf && deviateReplace.getDataType() != null) {
            ((YangLeaf)targetNode).setDataType(deviateReplace.getDataType());
        }
        if (targetNode instanceof YangLeafList && deviateReplace.getDataType() != null) {
            ((YangLeafList)targetNode).setDataType(deviateReplace.getDataType());
        }
        if (targetNode instanceof YangConfig) {
            ((YangConfig)((Object)targetNode)).setConfig(deviateReplace.isConfig());
        }
        if (targetNode instanceof YangUnits) {
            ((YangUnits)((Object)targetNode)).setUnits(deviateReplace.getUnits());
        }
        if (targetNode instanceof YangDefault) {
            ((YangDefault)((Object)targetNode)).setDefaultValueInString(deviateReplace.getDefaultValueInString());
        }
        if (targetNode instanceof YangMandatory) {
            ((YangMandatory)((Object)targetNode)).setMandatory(deviateReplace.isMandatory());
        }
        if (targetNode instanceof YangMinElementHolder) {
            ((YangMinElementHolder)((Object)targetNode)).setMinElements(deviateReplace.getMinElements());
        }
        if (targetNode instanceof YangMaxElementHolder) {
            ((YangMaxElementHolder)((Object)targetNode)).setMaxElements(deviateReplace.getMaxElements());
        }
    }

    public static YangSchemaNode findLeafNode(YangLeavesHolder target, String name) {
        List<YangLeafList> listOfleafList;
        List<YangLeaf> leaves = target.getListOfLeaf();
        if (leaves != null && !leaves.isEmpty()) {
            for (YangLeaf leaf : leaves) {
                if (!leaf.getName().equals(name)) continue;
                return leaf;
            }
        }
        if ((listOfleafList = target.getListOfLeafList()) != null && !listOfleafList.isEmpty()) {
            for (YangLeafList leafList : listOfleafList) {
                if (!leafList.getName().equals(name)) continue;
                return leafList;
            }
        }
        return null;
    }

    public static YangNode findRpcInput(YangNode rpc) {
        for (YangNode child = rpc.getChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof YangInput)) {
                continue;
            }
            return child;
        }
        return null;
    }

    public static YangNode findRpcOutput(YangNode rpc) {
        for (YangNode child = rpc.getChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof YangOutput)) {
                continue;
            }
            return child;
        }
        return null;
    }

    public static YangNode getParentSchemaContext(YangNode node) {
        while (!(node instanceof SchemaDataNode) && node != null) {
            if (node.getYangSchemaNodeType() == YangSchemaNodeType.YANG_AUGMENT_NODE) {
                node = ((YangAugment)node).getAugmentedNode();
                continue;
            }
            node = node.getParent();
        }
        return node;
    }

    public static YangSchemaNodeIdentifier getNodeIdFromSchemaId(SchemaId schemaId, String ns) {
        String namespace = schemaId.namespace();
        if (namespace == null) {
            namespace = ns;
        }
        DefaultYangNamespace nameSpace = new DefaultYangNamespace(namespace);
        YangSchemaNodeIdentifier id = new YangSchemaNodeIdentifier();
        id.setName(schemaId.name());
        id.setNameSpace(nameSpace);
        return id;
    }

    public static String errorMsg(String fmt, Object ... params) {
        return String.format(fmt, params);
    }

    public static LeafType getLeafTypeByDataType(YangType type, YangDataTypes dataType) {
        switch (dataType) {
            case BITS: 
            case ENUMERATION: 
            case IDENTITYREF: 
            case STRING: {
                return LeafType.STRING;
            }
            case BOOLEAN: 
            case EMPTY: {
                return LeafType.BOOLEAN;
            }
            case DECIMAL64: {
                return LeafType.BIG_DECIMAL;
            }
            case INT8: {
                return LeafType.BYTE;
            }
            case INT16: 
            case UINT8: {
                return LeafType.SHORT;
            }
            case INT32: 
            case UINT16: {
                return LeafType.INT;
            }
            case INT64: 
            case UINT32: {
                return LeafType.LONG;
            }
            case UINT64: {
                return LeafType.BIG_INTEGER;
            }
            case BINARY: {
                return LeafType.BYTE_ARRAY;
            }
            case DERIVED: {
                return DataModelUtils.getLeafTypeByDataType(type, ((YangDerivedInfo)type.getDataTypeExtendedInfo()).getEffectiveBuiltInType());
            }
            case LEAFREF: {
                return DataModelUtils.getLeafTypeByDataType(type, ((YangLeafRef)type.getDataTypeExtendedInfo()).getEffectiveDataType().getDataType());
            }
            case INSTANCE_IDENTIFIER: {
                return LeafType.STRING;
            }
            case UNION: {
                return LeafType.UNION;
            }
        }
        throw new IllegalArgumentException(E_DATATYPE);
    }
}

