/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel.utils.builtindatatype;

import java.io.Serializable;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.DataTypeException;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangBuiltInDataTypeInfo;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;

public class YangUint32
extends DefaultLocationInfo
implements YangBuiltInDataTypeInfo<YangUint32>,
Serializable {
    private static final long serialVersionUID = 8006201662L;
    private static final String MIN_KEYWORD = "min";
    private static final String MAX_KEYWORD = "max";
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    private long value;

    public YangUint32(String valueInString) {
        if (valueInString.matches(MIN_KEYWORD)) {
            this.value = 0L;
        } else if (valueInString.matches(MAX_KEYWORD)) {
            this.value = 0xFFFFFFFFL;
        } else {
            try {
                this.value = Long.parseLong(valueInString);
            }
            catch (Exception e) {
                throw new DataTypeException("YANG file error : Input value \"" + valueInString + "\" is not a valid uint32.");
            }
        }
        if (this.value < 0L) {
            throw new DataTypeException("YANG file error : " + valueInString + " is lesser than minimum value " + 0L + ".");
        }
        if (this.value > 0xFFFFFFFFL) {
            throw new DataTypeException("YANG file error : " + valueInString + " is greater than maximum value " + 0xFFFFFFFFL + ".");
        }
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public int compareTo(YangUint32 another) {
        return Long.compare(this.value, another.value);
    }

    @Override
    public YangDataTypes getYangType() {
        return YangDataTypes.UINT32;
    }
}

