/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel.utils.builtindatatype;

import java.io.Serializable;
import java.math.BigInteger;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.DataTypeException;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangBuiltInDataTypeInfo;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;

public class YangUint64
extends DefaultLocationInfo
implements YangBuiltInDataTypeInfo<YangUint64>,
Serializable {
    private static final long serialVersionUID = 8006201661L;
    private static final String MIN_KEYWORD = "min";
    private static final String MAX_KEYWORD = "max";
    public static final BigInteger MIN_VALUE = BigInteger.valueOf(0L);
    public static final BigInteger MAX_VALUE = new BigInteger("18446744073709551615");
    private BigInteger value;

    public YangUint64(String valueInString) {
        if (valueInString.matches(MIN_KEYWORD)) {
            this.value = MIN_VALUE;
        } else if (valueInString.matches(MAX_KEYWORD)) {
            this.value = MAX_VALUE;
        } else {
            try {
                this.value = new BigInteger(valueInString);
            }
            catch (Exception e) {
                throw new DataTypeException("YANG file error : Input value \"" + valueInString + "\" is not a valid uint64.");
            }
        }
        if (this.value.compareTo(MIN_VALUE) < 0) {
            throw new DataTypeException("YANG file error : " + valueInString + " is lesser than minimum value " + MIN_VALUE + ".");
        }
        if (this.value.compareTo(MAX_VALUE) > 0) {
            throw new DataTypeException("YANG file error : " + valueInString + " is greater than maximum value " + MAX_VALUE + ".");
        }
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public int compareTo(YangUint64 another) {
        return this.value.compareTo(another.value);
    }

    @Override
    public YangDataTypes getYangType() {
        return YangDataTypes.UINT64;
    }
}

