/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangEnum;
import org.onosproject.yang.compiler.datamodel.YangEnumeration;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class EnumListener {
    private EnumListener() {
    }

    public static void processEnumEntry(TreeWalkListener listener, GeneratedYangParser.EnumStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ENUM_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        YangEnum enumNode = new YangEnum();
        enumNode.setNamedValue(EnumListener.getValidNamedValue(ctx.string().getText()));
        enumNode.setLineNumber(ctx.getStart().getLine());
        enumNode.setCharPosition(ctx.getStart().getCharPositionInLine());
        enumNode.setFileName(listener.getFileName());
        listener.getParsedDataStack().push(enumNode);
    }

    private static String getValidNamedValue(String name) {
        if (name.contains("\"")) {
            name = name.replace("\"", "");
        }
        return name;
    }

    public static void processEnumExit(TreeWalkListener listener, GeneratedYangParser.EnumStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ENUM_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT);
        Parsable tmpEnumNode = listener.getParsedDataStack().peek();
        if (tmpEnumNode instanceof YangEnum) {
            listener.getParsedDataStack().pop();
            ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ENUM_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT);
            Parsable tmpNode = listener.getParsedDataStack().peek();
            switch (tmpNode.getYangConstructType()) {
                case ENUMERATION_DATA: {
                    YangEnumeration yangEnumeration = (YangEnumeration)tmpNode;
                    if (ctx.enumStatementBody() == null || ctx.enumStatementBody().valueStatement() == null) {
                        int maxValue = 0;
                        boolean isValuePresent = false;
                        for (YangEnum curEnum : yangEnumeration.getEnumSet()) {
                            if (curEnum.getValue() == Integer.MAX_VALUE) {
                                ParserException parserException = new ParserException("YANG file error : An enum value MUST be specified for enum substatements following the one with the current highest value");
                                parserException.setLine(ctx.getStart().getLine());
                                parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                                throw parserException;
                            }
                            if (maxValue > curEnum.getValue()) continue;
                            maxValue = curEnum.getValue();
                            isValuePresent = true;
                        }
                        if (isValuePresent) {
                            ++maxValue;
                        }
                        ((YangEnum)tmpEnumNode).setValue(maxValue);
                    }
                    try {
                        yangEnumeration.addEnumInfo((YangEnum)tmpEnumNode);
                        break;
                    }
                    catch (DataModelException e) {
                        ParserException parserException = new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.DUPLICATE_ENTRY, YangConstructType.ENUM_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT, e.getMessage()));
                        parserException.setLine(ctx.getStart().getLine());
                        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                        throw parserException;
                    }
                }
                default: {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.ENUM_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.ENUM_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT));
        }
    }
}

