/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangMinElement;
import org.onosproject.yang.compiler.datamodel.YangMinElementHolder;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class MinElementsListener {
    private MinElementsListener() {
    }

    public static void processMinElementsEntry(TreeWalkListener listener, GeneratedYangParser.MinElementsStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.MIN_ELEMENT_DATA, ctx.minValue().getText(), ListenerErrorLocation.ENTRY);
        int minElementValue = ListenerUtil.getValidNonNegativeIntegerValue(ctx.minValue().getText(), YangConstructType.MIN_ELEMENT_DATA, ctx);
        YangMinElement minElement = new YangMinElement();
        minElement.setMinElement(minElementValue);
        minElement.setLineNumber(ctx.getStart().getLine());
        minElement.setCharPosition(ctx.getStart().getCharPositionInLine());
        minElement.setFileName(listener.getFileName());
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (!(tmpData instanceof YangMinElementHolder)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.MIN_ELEMENT_DATA, ctx.minValue().getText(), ListenerErrorLocation.ENTRY));
        }
        YangMinElementHolder holder = (YangMinElementHolder)((Object)tmpData);
        holder.setMinElements(minElement);
    }
}

