/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangCase;
import org.onosproject.yang.compiler.datamodel.YangContainer;
import org.onosproject.yang.compiler.datamodel.YangGrouping;
import org.onosproject.yang.compiler.datamodel.YangInput;
import org.onosproject.yang.compiler.datamodel.YangList;
import org.onosproject.yang.compiler.datamodel.YangModule;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangNotification;
import org.onosproject.yang.compiler.datamodel.YangOutput;
import org.onosproject.yang.compiler.datamodel.YangSubModule;
import org.onosproject.yang.compiler.datamodel.YangUses;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.linker.impl.YangResolutionInfoImpl;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;

public final class UsesListener {
    private UsesListener() {
    }

    public static void processUsesEntry(TreeWalkListener listener, GeneratedYangParser.UsesStatementContext ctx) {
        YangUses usesNode;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.USES_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        UsesListener.validateSubStatementsCardinality(ctx);
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, ctx.string().getText(), YangConstructType.USES_DATA);
        Parsable curData = listener.getParsedDataStack().peek();
        if (curData instanceof YangModule || curData instanceof YangSubModule || curData instanceof YangContainer || curData instanceof YangList || curData instanceof YangUses || curData instanceof YangAugment || curData instanceof YangCase || curData instanceof YangGrouping || curData instanceof YangInput || curData instanceof YangOutput || curData instanceof YangNotification) {
            usesNode = YangDataModelFactory.getYangUsesNode(GeneratedLanguage.JAVA_GENERATION);
            usesNode.setLineNumber(ctx.getStart().getLine());
            usesNode.setCharPosition(ctx.getStart().getCharPositionInLine());
            usesNode.setFileName(listener.getFileName());
            YangNodeIdentifier nodeIdentifier = ListenerUtil.getValidNodeIdentifier(ctx.string().getText(), YangConstructType.USES_DATA, ctx);
            usesNode.setNodeIdentifier(nodeIdentifier);
            usesNode.setCurrentGroupingDepth(listener.getGroupingDepth());
            YangNode curNode = (YangNode)((Object)curData);
            try {
                curNode.addChild(usesNode);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.USES_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.USES_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(usesNode);
    }

    public static void processUsesExit(TreeWalkListener listener, GeneratedYangParser.UsesStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.USES_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT);
        Parsable parsableUses = listener.getParsedDataStack().pop();
        if (!(parsableUses instanceof YangUses)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.USES_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT));
        }
        YangUses uses = (YangUses)parsableUses;
        int errorLine = ctx.getStart().getLine();
        int errorPosition = ctx.getStart().getCharPositionInLine();
        Parsable parentNode = listener.getParsedDataStack().peek();
        if (!(parentNode instanceof YangNode)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.USES_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT));
        }
        YangResolutionInfoImpl<YangUses> resolutionInfo = new YangResolutionInfoImpl<YangUses>(uses, (YangNode)((Object)parentNode), errorLine, errorPosition);
        UsesListener.addToResolutionList(resolutionInfo, ctx);
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.UsesStatementContext ctx) {
        ListenerValidation.validateCardinalityMaxOne(ctx.whenStatement(), YangConstructType.WHEN_DATA, YangConstructType.USES_DATA, ctx.string().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.USES_DATA, ctx.string().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.USES_DATA, ctx.string().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.USES_DATA, ctx.string().getText());
    }

    private static void addToResolutionList(YangResolutionInfoImpl<YangUses> resolutionInfo, GeneratedYangParser.UsesStatementContext ctx) {
        try {
            DataModelUtils.addResolutionInfo(resolutionInfo);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.USES_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT, e.getMessage()));
        }
    }
}

