/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.plugin.buck;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import org.onosproject.yang.compiler.api.YangCompiledOutput;
import org.onosproject.yang.compiler.api.YangCompilerException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.plugin.buck.YangParsingException;
import org.onosproject.yang.compiler.tool.impl.DefaultYangCompilationParam;
import org.onosproject.yang.compiler.tool.impl.YangCompilerManager;
import org.onosproject.yang.compiler.utils.UtilConstants;

public class YangGenerator {
    private final List<File> models;
    private final List<String> depJar;
    private String outputDirectory;
    private YangCompiledOutput output;

    YangGenerator(List<File> models, String outputDirectory, List<String> depJar) {
        this.models = models;
        this.depJar = depJar;
        this.outputDirectory = outputDirectory + UtilConstants.SLASH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws YangParsingException {
        Class<YangGenerator> clazz = YangGenerator.class;
        synchronized (YangGenerator.class) {
            YangCompilerManager compiler = new YangCompilerManager();
            DefaultYangCompilationParam param = new DefaultYangCompilationParam();
            for (String jar : this.depJar) {
                try {
                    File path = DataModelUtils.parseDepSchemaPath(jar, this.outputDirectory);
                    if (path == null) continue;
                    param.addDependentSchema(Paths.get(path.getAbsolutePath(), new String[0]));
                }
                catch (IOException e) {
                    throw new YangCompilerException("Failed to parse dependent schema path");
                }
            }
            param.setCodeGenDir(Paths.get(this.outputDirectory, new String[0]));
            param.setMetadataGenDir(Paths.get(this.outputDirectory + UtilConstants.SLASH + "yang/resources" + UtilConstants.SLASH, new String[0]));
            for (File file : this.models) {
                param.addYangFile(Paths.get(file.getAbsolutePath(), new String[0]));
            }
            try {
                this.output = compiler.compileYangFiles(param);
            }
            catch (IOException e) {
                throw new YangParsingException(e);
            }
            return;
        }
    }

    public YangCompiledOutput output() {
        return this.output;
    }
}

