/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.plugin.buck;

import com.facebook.buck.io.ProjectFilesystem;
import com.facebook.buck.model.UnflavoredBuildTarget;
import com.facebook.buck.rules.BuildRule;
import com.facebook.buck.step.AbstractExecutionStep;
import com.facebook.buck.step.ExecutionContext;
import com.facebook.buck.step.StepExecutionResult;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.onosproject.yang.compiler.plugin.buck.YangGenerator;
import org.onosproject.yang.compiler.plugin.buck.YangParsingException;
import org.onosproject.yang.compiler.utils.UtilConstants;

public class YangStep
extends AbstractExecutionStep {
    private static final String DESCRIPTION = "yang-compile";
    private final ImmutableSortedSet<BuildRule> deps;
    private final ProjectFilesystem filesystem;
    private final List<Path> srcs;
    private final Path output;

    YangStep(ProjectFilesystem filesystem, List<Path> srcs, Path genSourcesDirectory, ImmutableSortedSet<BuildRule> deps) {
        super(DESCRIPTION);
        this.filesystem = filesystem;
        this.srcs = srcs;
        this.deps = deps;
        this.output = genSourcesDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExecutionResult execute(ExecutionContext executionContext) throws IOException, InterruptedException {
        Class<YangStep> clazz = YangStep.class;
        synchronized (YangStep.class) {
            List<File> sourceFiles = this.srcs.stream().map(Path::toFile).collect(Collectors.toList());
            try {
                new YangGenerator(sourceFiles, this.output.toString(), this.getJarPaths()).execute();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return StepExecutionResult.SUCCESS;
            }
            catch (YangParsingException e) {
                executionContext.getConsole().printErrorText(e.getMessage());
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return StepExecutionResult.ERROR;
            }
        }
    }

    private List<String> getJarPaths() {
        ArrayList<String> depJarPaths = new ArrayList<String>();
        if (this.deps != null) {
            for (BuildRule rule : this.deps) {
                String name = rule.getBuildTarget().getFullyQualifiedName();
                if (name.contains("//lib:")) continue;
                StringBuilder builder = new StringBuilder();
                if (name.contains(":")) {
                    Path thisPath = rule.getPathToOutput();
                    if (thisPath != null) {
                        depJarPaths.add(thisPath.toString());
                    }
                } else {
                    builder.append(this.filesystem.getRootPath().toString()).append(UtilConstants.SLASH).append(this.filesystem.getBuckPaths().getGenDir()).append(UtilConstants.SLASH);
                    UnflavoredBuildTarget uBt = rule.getBuildTarget().getUnflavoredBuildTarget();
                    String[] array = uBt.getBaseName().split(UtilConstants.SLASH);
                    for (int i = 2; i < array.length; ++i) {
                        builder.append(array[i]).append(UtilConstants.SLASH);
                    }
                    builder.append("lib__").append(uBt.getShortName()).append("__output").append(UtilConstants.SLASH).append(uBt.getShortName()).append(".jar");
                }
                if (builder.length() == 0) continue;
                depJarPaths.add(builder.toString());
            }
        }
        return depJarPaths;
    }
}

