/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.tool.impl;

import com.google.common.base.MoreObjects;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.onosproject.yang.compiler.api.YangCompilationParam;

public class DefaultYangCompilationParam
implements YangCompilationParam {
    private final Set<Path> yangFiles = new LinkedHashSet<Path>();
    private final Set<Path> dependentSchemas = new LinkedHashSet<Path>();
    private Path codeGenDir;
    private Path metaDataPath;

    @Override
    public Set<Path> getYangFiles() {
        return this.yangFiles;
    }

    @Override
    public void addYangFile(Path path) {
        this.yangFiles.add(path);
    }

    @Override
    public Set<Path> getDependentSchemas() {
        return this.dependentSchemas;
    }

    @Override
    public void addDependentSchema(Path path) {
        this.dependentSchemas.add(path);
    }

    @Override
    public Path getCodeGenDir() {
        return this.codeGenDir;
    }

    @Override
    public void setCodeGenDir(Path path) {
        this.codeGenDir = path;
    }

    @Override
    public Path getMetadataGenDir() {
        return this.metaDataPath;
    }

    @Override
    public void setMetadataGenDir(Path path) {
        this.metaDataPath = path;
    }

    public int hashCode() {
        return Objects.hash(this.yangFiles, this.dependentSchemas, this.codeGenDir, this.metaDataPath);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        DefaultYangCompilationParam that = (DefaultYangCompilationParam)obj;
        return this.yangFiles.size() == that.yangFiles.size() && this.dependentSchemas.size() == that.dependentSchemas.size() && this.yangFiles.containsAll(that.yangFiles) && this.dependentSchemas.containsAll(that.dependentSchemas) && Objects.equals(this.codeGenDir, that.codeGenDir) && Objects.equals(this.metaDataPath, that.metaDataPath);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("yangFilePath", this.yangFiles).add("dependentSchemas", this.dependentSchemas).add("codeGenDir", (Object)this.codeGenDir).add("metaDataPath", (Object)this.metaDataPath).toString();
    }
}

