/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.tool.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import org.onosproject.yang.compiler.api.YangCompiledOutput;
import org.onosproject.yang.model.YangModel;

public class DefaultYangCompiledOutput
implements YangCompiledOutput {
    private final YangModel model;
    private final Set<Path> generatedJava;

    public DefaultYangCompiledOutput(YangModel model, Set<Path> generatedJava) {
        Preconditions.checkNotNull((Object)model);
        Preconditions.checkNotNull(generatedJava);
        this.model = model;
        this.generatedJava = generatedJava;
    }

    @Override
    public YangModel getYangModel() {
        return this.model;
    }

    @Override
    public Set<Path> getGeneratedJava() {
        return this.generatedJava;
    }

    public int hashCode() {
        return Objects.hash(this.model, this.generatedJava);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        DefaultYangCompiledOutput that = (DefaultYangCompiledOutput)obj;
        return this.generatedJava.size() == that.generatedJava.size() && this.generatedJava.containsAll(that.generatedJava) && Objects.equals(this.model, that.model);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("yangModel", (Object)this.model).add("generatedJava", this.generatedJava).toString();
    }
}

