/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava.javamodel;

import java.io.IOException;
import org.onosproject.yang.compiler.datamodel.RpcNotificationContainer;
import org.onosproject.yang.compiler.datamodel.YangInput;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangOutput;
import org.onosproject.yang.compiler.datamodel.javadatamodel.YangJavaRpc;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.translator.exception.TranslatorException;
import org.onosproject.yang.compiler.translator.tojava.JavaAttributeInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGenerator;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.TempJavaCodeFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yang.compiler.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.YangJavaModelUtils;
import org.onosproject.yang.compiler.translator.tojava.utils.TranslatorErrorType;
import org.onosproject.yang.compiler.translator.tojava.utils.TranslatorUtils;
import org.onosproject.yang.compiler.utils.io.YangPluginConfig;

public class YangJavaRpcTranslator
extends YangJavaRpc
implements JavaCodeGenerator,
JavaCodeGeneratorInfo {
    private static final long serialVersionUID = 806201622L;
    private transient TempJavaCodeFragmentFiles tempJavaCodeFragmentFiles;

    public YangJavaRpcTranslator() {
        this.setJavaFileInfo(new JavaFileInfoTranslator());
        this.getJavaFileInfo().setGeneratedFileTypes(32768);
    }

    @Override
    public JavaFileInfoTranslator getJavaFileInfo() {
        if (this.javaFileInfo == null) {
            throw new TranslatorException("missing java info in java datamodel node " + this.getName());
        }
        return (JavaFileInfoTranslator)this.javaFileInfo;
    }

    @Override
    public void setJavaFileInfo(JavaFileInfoTranslator javaInfo) {
        this.javaFileInfo = javaInfo;
    }

    @Override
    public TempJavaCodeFragmentFiles getTempJavaCodeFragmentFiles() {
        return this.tempJavaCodeFragmentFiles;
    }

    @Override
    public void setTempJavaCodeFragmentFiles(TempJavaCodeFragmentFiles fileHandle) {
        this.tempJavaCodeFragmentFiles = fileHandle;
    }

    @Override
    public void generateCodeEntry(YangPluginConfig yangPlugin) throws TranslatorException {
        try {
            YangJavaModelUtils.generateCodeOfNode(this, yangPlugin);
        }
        catch (IOException e) {
            throw new TranslatorException("Failed to prepare generate code entry for RPC node " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + " " + e.getLocalizedMessage());
        }
    }

    @Override
    public void generateCodeExit() throws TranslatorException {
        YangNode parent = DataModelUtils.getParentNodeInGenCode(this);
        if (!(parent instanceof RpcNotificationContainer)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.INVALID_PARENT_NODE, this));
        }
        TempJavaServiceFragmentFiles tempJavaFragmentFiles = ((TempJavaCodeFragmentFilesContainer)((Object)this.getParent())).getTempJavaCodeFragmentFiles().getServiceTempFiles();
        JavaAttributeInfo javaAttributeInfoOfInput = null;
        JavaAttributeInfo javaAttributeInfoOfOutput = null;
        for (YangNode yangNode = this.getChild(); yangNode != null; yangNode = yangNode.getNextSibling()) {
            if (yangNode instanceof YangInput) {
                javaAttributeInfoOfInput = tempJavaFragmentFiles.getChildNodeAsAttributeInParentService(yangNode, this.getParent(), this.getJavaClassNameOrBuiltInType());
                continue;
            }
            if (yangNode instanceof YangOutput) {
                javaAttributeInfoOfOutput = tempJavaFragmentFiles.getChildNodeAsAttributeInParentService(yangNode, this.getParent(), this.getJavaClassNameOrBuiltInType());
                continue;
            }
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.INVALID_CHILD_NODE, this));
        }
        try {
            ((TempJavaCodeFragmentFilesContainer)((Object)parent)).getTempJavaCodeFragmentFiles().getServiceTempFiles().addJavaSnippetInfoToApplicableTempFiles(javaAttributeInfoOfInput, javaAttributeInfoOfOutput, this.getJavaClassNameOrBuiltInType());
        }
        catch (IOException e) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.FAIL_AT_EXIT, this, e.getLocalizedMessage()));
        }
        try {
            YangJavaModelUtils.generateJava(32768, this);
        }
        catch (IOException e) {
            throw new TranslatorException("Failed to generate code for RPC node " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + " " + e.getLocalizedMessage());
        }
    }
}

