/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava.utils;

import org.onosproject.yang.compiler.datamodel.RpcNotificationContainer;
import org.onosproject.yang.compiler.datamodel.YangCase;
import org.onosproject.yang.compiler.datamodel.YangIdentity;
import org.onosproject.yang.compiler.datamodel.YangList;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNotification;
import org.onosproject.yang.compiler.translator.exception.TranslatorException;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yang.compiler.translator.tojava.utils.BracketType;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaExtendsListHolder;
import org.onosproject.yang.compiler.translator.tojava.utils.StringGenerator;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;

final class ClassDefinitionGenerator {
    private ClassDefinitionGenerator() {
    }

    static String generateClassDefinition(int genFileTypes, String yangName) {
        switch (genFileTypes) {
            case 64: 
            case 128: {
                return ClassDefinitionGenerator.getTypeClassDefinition(yangName);
            }
            case 32: {
                return ClassDefinitionGenerator.getEnumClassDefinition(yangName);
            }
        }
        return null;
    }

    static String generateClassDefinition(int genFileTypes, String yangName, YangNode curNode) {
        switch (genFileTypes) {
            case 1: {
                return ClassDefinitionGenerator.getInterfaceDefinition(yangName, curNode);
            }
            case 8: {
                return ClassDefinitionGenerator.getImplClassDefinition(yangName, curNode);
            }
            case 16: {
                return ClassDefinitionGenerator.getRpcInterfaceDefinition(yangName, curNode);
            }
            case 256: {
                String eventName = yangName + "Subject";
                return ClassDefinitionGenerator.getEventDefinition(yangName, eventName);
            }
            case 512: {
                return ClassDefinitionGenerator.getEventListenerDefinition(yangName);
            }
            case 4096: {
                return ClassDefinitionGenerator.getKeyClassDefinition(yangName, curNode);
            }
            case 1024: {
                return ClassDefinitionGenerator.getClassDefinition(yangName);
            }
            case 2048: {
                return ClassDefinitionGenerator.getIdentityClassDefinition(yangName, curNode);
            }
            case 8192: {
                return ClassDefinitionGenerator.getRpcHandlerClassDefinition();
            }
            case 16384: {
                return ClassDefinitionGenerator.getRpcRegisterClassDefination();
            }
            case 32768: {
                return ClassDefinitionGenerator.getRpcCommandClassDefination(curNode);
            }
            case 65536: {
                return ClassDefinitionGenerator.getRpcExtendedCommandClassDefination();
            }
        }
        return null;
    }

    private static String getEnumClassDefinition(String yangName) {
        return StringGenerator.getDefaultDefinition("enum", yangName, "public");
    }

    private static String getInterfaceDefinition(String yangName, YangNode curNode) {
        String clsDef = ClassDefinitionGenerator.getClassDefinitionForWhenExtended(curNode, yangName, 1);
        if (clsDef != null) {
            return clsDef;
        }
        return StringGenerator.getDefaultDefinition("interface", yangName, "public");
    }

    private static String getImplClassDefinition(String yangName, YangNode curNode) {
        String clsDef = ClassDefinitionGenerator.getClassDefinitionForWhenExtended(curNode, yangName, 8);
        if (clsDef != null) {
            return clsDef;
        }
        return StringGenerator.getDefaultDefinitionWithImpl("class", StringGenerator.getDefaultName(yangName), "public", yangName);
    }

    private static String getClassDefinition(String yangName) {
        return StringGenerator.getDefaultDefinition("class", yangName, "public");
    }

    private static String getKeyClassDefinition(String yangName, YangNode node) {
        String keyInfo = "KeyInfo" + StringGenerator.brackets(BracketType.OPEN_CLOSE_DIAMOND_WITH_VALUE, "Default" + YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(node.getJavaClassNameOrBuiltInType(), null)), null);
        return StringGenerator.getDefinitionWithImplements("class", yangName, "public", keyInfo);
    }

    private static String getIdentityClassDefinition(String yangName, YangNode curNode) {
        String error = StringGenerator.getErrorMsg("Expected java identity instance node ", curNode.getName(), curNode.getLineNumber(), curNode.getCharPosition(), curNode.getFileName());
        if (!(curNode instanceof YangIdentity)) {
            throw new TranslatorException(error);
        }
        YangIdentity identity = (YangIdentity)curNode;
        String mod = StringGenerator.getSpecificModifier("public", "abstract");
        if (identity.getBaseNode() != null) {
            YangIdentity baseIdentity = identity.getBaseNode().getReferredIdentity();
            if (baseIdentity == null) {
                throw new TranslatorException(error);
            }
            JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)((Object)baseIdentity)).getJavaFileInfo();
            return StringGenerator.getDefaultDefinitionWithExtends("class", yangName, mod, YangIoUtils.getCapitalCase(fileInfo.getJavaName()));
        }
        return StringGenerator.getDefaultDefinition("class", yangName, mod);
    }

    private static String getTypeClassDefinition(String yangName) {
        return StringGenerator.getDefaultDefinition("class", yangName, StringGenerator.getSpecificModifier("public", "final"));
    }

    private static String getRpcInterfaceDefinition(String yangName, YangNode curNode) {
        JavaExtendsListHolder holder = ((TempJavaCodeFragmentFilesContainer)((Object)curNode)).getTempJavaCodeFragmentFiles().getServiceTempFiles().getJavaExtendsListHolder();
        if (holder.getExtendsList() != null && !holder.getExtendsList().isEmpty()) {
            for (curNode = curNode.getChild(); curNode != null; curNode = curNode.getNextSibling()) {
                if (!(curNode instanceof YangNotification)) continue;
                return ClassDefinitionGenerator.getRpcInterfaceDefinitionWhenItExtends(yangName);
            }
        }
        if (yangName.matches(".+Service")) {
            return StringGenerator.getDefaultDefinition("interface", yangName, "public");
        }
        String name = StringGenerator.getSuffixedName(yangName.substring(0, yangName.length() - 7), "Service");
        return StringGenerator.getDefaultDefinitionWithImpl("class", yangName, "public", name);
    }

    private static String getRpcInterfaceDefinitionWhenItExtends(String yangName) {
        StringBuilder newString = new StringBuilder(yangName);
        newString.replace(yangName.lastIndexOf("Service"), yangName.lastIndexOf("Service") + 7, "");
        return StringGenerator.getDefaultDefinitionWithExtends("interface", yangName, "public", StringGenerator.getEventExtendsString(StringGenerator.getSuffixedName(newString.toString(), "Event"), "ListenerService", StringGenerator.getSuffixedName(newString.toString(), "EventListener")));
    }

    private static String getEventDefinition(String javaName, String eventName) {
        return StringGenerator.getDefaultDefinitionWithExtends("class", javaName, "public", StringGenerator.getEventExtendsString(StringGenerator.getSuffixedName(javaName, ".Type"), "AbstractEvent", eventName));
    }

    private static String getEventListenerDefinition(String javaName) {
        String name = javaName.substring(0, javaName.length() - 8);
        return StringGenerator.getDefaultDefinitionWithExtends("interface", javaName, "public", "EventListener" + StringGenerator.brackets(BracketType.OPEN_CLOSE_DIAMOND_WITH_VALUE, name, null));
    }

    private static String getClassDefinitionForWhenExtended(YangNode curNode, String yangName, int genFileTypes) {
        JavaExtendsListHolder holder = ((TempJavaCodeFragmentFilesContainer)((Object)curNode)).getTempJavaCodeFragmentFiles().getBeanTempFiles().getJavaExtendsListHolder();
        StringBuilder def = new StringBuilder();
        if (holder.getExtendsList() != null && !holder.getExtendsList().isEmpty()) {
            def.append("public").append(" ");
            switch (genFileTypes) {
                case 1: {
                    def.append("interface").append(" ").append(yangName).append(" ").append("extends").append(" ");
                    def = new StringBuilder(ClassDefinitionGenerator.getDefinitionString(def.toString(), holder));
                    break;
                }
                case 8: {
                    if (curNode instanceof RpcNotificationContainer) {
                        def.append("class").append(" ").append(yangName).append("OpParam").append(" ").append("extends").append(" ");
                    } else {
                        def.append("class").append(" ").append("Default").append(yangName).append(" ").append("extends").append(" ");
                    }
                    def = curNode instanceof YangCase ? new StringBuilder(ClassDefinitionGenerator.getDefinitionStringForCase(def.toString(), holder)) : new StringBuilder(ClassDefinitionGenerator.getDefinitionString(def.toString(), holder));
                    if (curNode instanceof YangList) {
                        String multiInstanceObj = "MultiInstanceObject" + StringGenerator.brackets(BracketType.OPEN_CLOSE_DIAMOND_WITH_VALUE, YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(yangName, null)) + "Keys", null);
                        def.append("\n").append("        ").append("implements").append(" ").append(yangName).append(",").append(" ").append(multiInstanceObj);
                        break;
                    }
                    def.append("implements").append(" ").append(yangName);
                    break;
                }
                default: {
                    return null;
                }
            }
            return def.append(" ").append("{").append("\n").toString();
        }
        return null;
    }

    private static String getDefinitionString(String def, JavaExtendsListHolder holder) {
        StringBuilder builder = new StringBuilder(def);
        for (JavaQualifiedTypeInfoTranslator info : holder.getExtendsList()) {
            String str = holder.getExtendedClassStore().get(info) == false ? info.getClassInfo() + "," + " " : info.getPkgInfo() + "." + info.getClassInfo() + "," + " ";
            builder.append(str);
        }
        def = builder.toString();
        return YangIoUtils.trimAtLast(def, ",");
    }

    private static String getDefinitionStringForCase(String def, JavaExtendsListHolder holder) {
        StringBuilder builder = new StringBuilder(def);
        for (JavaQualifiedTypeInfoTranslator info : holder.getExtendsList()) {
            if (!info.getClassInfo().equals("InnerModelObject")) continue;
            builder.append(info.getClassInfo() + "," + " ");
        }
        def = builder.toString();
        return YangIoUtils.trimAtLast(def, ",");
    }

    private static String getRpcHandlerClassDefinition() {
        return StringGenerator.getDefinitionWithImplements("class", "DefaultRpcHandler", "public", "RpcHandler");
    }

    private static String getRpcRegisterClassDefination() {
        return StringGenerator.getDefaultDefinition("class", "RegisterRpc", "public");
    }

    private static String getRpcCommandClassDefination(YangNode yangNode) {
        String className = YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(yangNode.getJavaClassNameOrBuiltInType(), null)) + "Command";
        return StringGenerator.getDefaultDefinitionWithExtends("class", className, "public", "RpcExtendedCommand");
    }

    private static String getRpcExtendedCommandClassDefination() {
        return StringGenerator.getAbstractClassDefinitionWithExtends("class", "RpcExtendedCommand", "public", "RpcCommand");
    }
}

