/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava.utils;

import java.util.Collections;
import java.util.List;
import org.onosproject.yang.compiler.datamodel.YangCompilerAnnotation;
import org.onosproject.yang.compiler.datamodel.YangDataStructure;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.translator.exception.TranslatorException;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yang.compiler.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yang.compiler.translator.tojava.utils.StringGenerator;
import org.onosproject.yang.compiler.utils.UtilConstants;
import org.onosproject.yang.compiler.utils.io.impl.JavaDocGen;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;

public final class JavaCodeSnippetGen {
    private JavaCodeSnippetGen() {
    }

    public static String getFileHeaderComment() {
        return null;
    }

    static String getImportText(JavaQualifiedTypeInfoTranslator importInfo) {
        return StringGenerator.getImportString(importInfo.getPkgInfo(), importInfo.getClassInfo());
    }

    public static String getJavaAttributeDefinition(String typePkg, String attrType, String attrName, boolean isList, String accessType, YangCompilerAnnotation annotation) {
        StringBuilder attrDef = new StringBuilder("    ");
        attrDef.append(accessType).append(" ");
        if (!isList) {
            if (typePkg != null) {
                attrDef.append(typePkg).append(".");
            }
            attrDef.append(attrType).append(" ").append(attrName);
            if (attrName.equals("valueLeafFlags")) {
                attrDef.append(" ").append("=").append(" ").append("new").append(" ").append("BitSet").append("()");
            }
            attrDef.append(StringGenerator.signatureClose());
        } else {
            StringBuilder type = new StringBuilder();
            if (typePkg != null) {
                type.append(typePkg).append(".");
            }
            type.append(attrType);
            JavaCodeSnippetGen.addAttrStartDef(annotation, attrDef, type.toString());
            JavaCodeSnippetGen.addAttrEndDef(attrDef, attrName);
        }
        return attrDef.toString();
    }

    private static void addAttrStartDef(YangCompilerAnnotation annotation, StringBuilder attrDef, String type) {
        YangDataStructure ds = MethodsGenerator.getYangDataStructure(annotation);
        if (ds != null) {
            switch (ds) {
                case QUEUE: {
                    attrDef.append("Queue").append("<");
                    break;
                }
                case SET: {
                    attrDef.append("Set").append("<");
                    break;
                }
                case MAP: {
                    attrDef.append("Map").append("<").append(type).append("Keys").append(",");
                    break;
                }
                default: {
                    attrDef.append("List").append("<");
                    break;
                }
            }
        } else {
            attrDef.append("List").append("<");
        }
        attrDef.append(type);
    }

    private static void addAttrEndDef(StringBuilder attrDef, String attrName) {
        attrDef.append(">").append(" ").append(attrName).append(StringGenerator.signatureClose());
    }

    public static String generateEnumAttributeString(String name, int value) {
        String enumName = JavaIdentifierSyntax.getEnumJavaAttribute(name);
        return JavaDocGen.enumJavaDocForInnerClass(name) + "        " + enumName.toUpperCase() + StringGenerator.getOpenCloseParaWithValue(value + "") + "," + "\n";
    }

    public static String generateEnumAttributeStringWithSchemaName(String name, int value) {
        String enumName = JavaIdentifierSyntax.getEnumJavaAttribute(name);
        String str = value + "," + " " + "\"" + name + "\"";
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.ENUM_ATTRIBUTE, name, false, null) + "    " + enumName.toUpperCase() + StringGenerator.getOpenCloseParaWithValue(str) + "," + "\n";
    }

    public static List<String> sortImports(List<String> imports) {
        Collections.sort(imports);
        return imports;
    }

    static String getEventEnumTypeStart() {
        return "\n    " + StringGenerator.getDefaultDefinition("enum", "Type", "public");
    }

    public static void addListenersImport(YangNode curNode, List<String> imports, UtilConstants.Operation operation) {
        TempJavaServiceFragmentFiles tempFiles = ((JavaCodeGeneratorInfo)((Object)curNode)).getTempJavaCodeFragmentFiles().getServiceTempFiles();
        String thisImport = tempFiles.getJavaImportData().getListenerServiceImport();
        JavaCodeSnippetGen.performOperationOnImports(imports, thisImport, operation);
    }

    private static List<String> performOperationOnImports(List<String> imports, String curImport, UtilConstants.Operation operation) {
        switch (operation) {
            case ADD: {
                imports.add(curImport);
                break;
            }
            case REMOVE: {
                imports.remove(curImport);
                break;
            }
            default: {
                throw new TranslatorException("Invalid operation type");
            }
        }
        JavaCodeSnippetGen.sortImports(imports);
        return imports;
    }

    static String getEnumsValueAttribute(String className) {
        return JavaCodeSnippetGen.getJavaAttributeDefinition(null, "int", className, false, "private", null) + JavaCodeSnippetGen.getJavaAttributeDefinition(null, "String", "schemaName", false, "private", null) + "\n";
    }

    static String addStaticAttributeIntRange(String modifier, boolean addFirst) {
        if (addFirst) {
            return JavaCodeSnippetGen.getTypeConflictAttributeStrings(modifier, "static final int INT32_MIN_RANGE = -2147483648;\n", "static final int INT32_MAX_RANGE = 2147483647;");
        }
        return JavaCodeSnippetGen.getTypeConflictAttributeStrings(modifier, "static final int UINT16_MIN_RANGE = 0;\n", "static final int UINT16_MAX_RANGE = 2147483647;");
    }

    static String addStaticAttributeLongRange(String modifier, boolean addFirst) {
        if (addFirst) {
            return JavaCodeSnippetGen.getTypeConflictAttributeStrings(modifier, "static final BigInteger INT64_MIN_RANGE = new BigInteger(\"-9223372036854775808\");\n", "static final BigInteger INT64_MAX_RANGE = new BigInteger(\"9223372036854775807\");");
        }
        return JavaCodeSnippetGen.getTypeConflictAttributeStrings(modifier, "static final BigInteger UINT32_MIN_RANGE = new BigInteger(\"0\");\n", "static final BigInteger UINT32_MAX_RANGE = new BigInteger(\"9223372036854775807\");");
    }

    static String addStaticAttributeShortRange(String modifier, boolean addFirst) {
        if (addFirst) {
            return JavaCodeSnippetGen.getTypeConflictAttributeStrings(modifier, "static final int INT16_MIN_RANGE = -32768;\n", "static final int INT16_MAX_RANGE = 32767;");
        }
        return JavaCodeSnippetGen.getTypeConflictAttributeStrings(modifier, "static final int UINT8_MIN_RANGE = 0;\n", "static final int UINT8_MAX_RANGE = 32767;");
    }

    private static String getTypeConflictAttributeStrings(String modifier, String attr1, String att2) {
        return "    " + modifier + " " + attr1 + "    " + modifier + " " + att2 + "\n";
    }

    static String getSetValueParaForUnionClass() {
        String[] array = new String[]{"\n", ";"};
        return YangIoUtils.trimAtLast(JavaCodeSnippetGen.getJavaAttributeDefinition(null, "BitSet", "setValue", false, "private", null), array) + " " + "=" + " " + "new" + " " + "BitSet" + "()" + StringGenerator.signatureClose();
    }
}

