/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.model;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.onosproject.yang.model.ModelObject;

public abstract class InnerModelObject
extends ModelObject {
    private final ConcurrentMap<Class<? extends InnerModelObject>, InnerModelObject> augments = new ConcurrentHashMap<Class<? extends InnerModelObject>, InnerModelObject>();

    protected InnerModelObject() {
        super(ModelObject.ModelObjectType.NON_ATOMIC);
    }

    public void addAugmentation(InnerModelObject obj) {
        this.augments.put(obj.getClass(), obj);
    }

    public void removeAugmentation(InnerModelObject obj) {
        this.augments.remove(obj.getClass());
    }

    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {
        return ImmutableMap.copyOf(this.augments);
    }

    public <T extends InnerModelObject> T augmentation(Class<T> c) {
        return (T)((InnerModelObject)this.augments.get(c));
    }
}

