/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.LeafListKey;
import org.onosproject.yang.model.LeafNode;
import org.onosproject.yang.model.ListKey;
import org.onosproject.yang.model.ModelException;
import org.onosproject.yang.model.NodeKey;

public final class InnerNode
extends DataNode {
    private Map<NodeKey, DataNode> childNodes = new LinkedHashMap<NodeKey, DataNode>();

    public Map<NodeKey, DataNode> childNodes() {
        return this.childNodes;
    }

    public InnerNode(Builder builder) {
        super(builder);
        this.childNodes = builder.childNodes;
    }

    public static Builder builder(String name, String nameSpace) {
        return new Builder(name, nameSpace);
    }

    @Override
    public Builder copyBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends DataNode.Builder<Builder> {
        private Map<NodeKey, DataNode> childNodes = new LinkedHashMap<NodeKey, DataNode>();

        protected Builder(String name, String namespace) {
            this.keyBuilder = NodeKey.builder().schemaId(name, namespace);
        }

        public Builder(InnerNode node) {
            super(node);
            this.childNodes = node.childNodes;
        }

        public Builder addNode(DataNode node) {
            this.childNodes.put(node.key(), node);
            return this;
        }

        public Map<NodeKey, DataNode> childNodes() {
            return this.childNodes;
        }

        @Override
        public InnerNode build() {
            if (this.type == null) {
                throw new IllegalStateException("node should have a type.");
            }
            if (this.key == null) {
                this.key = this.keyBuilder.build();
            }
            return new InnerNode(this);
        }

        @Override
        public Builder createChildBuilder(String name, String nameSpace) {
            return (Builder)InnerNode.builder(name, nameSpace).parent(this);
        }

        @Override
        public LeafNode.Builder createChildBuilder(String name, String nameSpace, Object value) {
            return ((LeafNode.Builder)LeafNode.builder(name, nameSpace).parent(this)).value(value);
        }

        @Override
        public Builder deleteChild(NodeKey key) {
            this.childNodes.remove(key);
            return this;
        }

        @Override
        public Builder getChildBuilder(NodeKey nodeKey) {
            DataNode node = this.childNodes.get(nodeKey);
            if (node == null) {
                throw new IllegalArgumentException("Invalid key: no child nodes found for given key: " + nodeKey);
            }
            return (Builder)node.copyBuilder().parent(this);
        }

        @Override
        public Builder addKeyLeaf(String name, String nameSpace, Object val) {
            ListKey.ListKeyBuilder listKeyBuilder;
            if (!(this.keyBuilder instanceof ListKey.ListKeyBuilder)) {
                if (this.keyBuilder instanceof LeafListKey.LeafListKeyBuilder) {
                    throw new ModelException("Leaf must be the terminal node");
                }
                listKeyBuilder = new ListKey.ListKeyBuilder(this.keyBuilder);
            } else {
                listKeyBuilder = (ListKey.ListKeyBuilder)this.keyBuilder;
            }
            listKeyBuilder.addKeyLeaf(name, nameSpace, val);
            this.keyBuilder = listKeyBuilder;
            return this;
        }

        @Override
        public LeafNode.Builder addLeafListValue(Object val) {
            throw new IllegalStateException("node is not of leaf list type.");
        }
    }
}

