/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.model;

import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.model.LeafListKey;
import org.onosproject.yang.model.ListKey;
import org.onosproject.yang.model.ModelException;
import org.onosproject.yang.model.NodeKey;

public final class LeafNode
extends DataNode {
    private Object value;

    public Object value() {
        return this.value;
    }

    public String asString() {
        return String.valueOf(this.value);
    }

    public LeafNode(Builder builder) {
        super(builder);
        this.value = builder.value;
    }

    public static Builder builder(String name, String nameSpace) {
        return new Builder(name, nameSpace);
    }

    @Override
    public Builder copyBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends DataNode.Builder<Builder> {
        private Object value;

        protected Builder(String name, String namespace) {
            this.keyBuilder = NodeKey.builder().schemaId(name, namespace);
        }

        public Builder(LeafNode node) {
            super(node);
            this.value = node.value;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        @Override
        public InnerNode.Builder createChildBuilder(String name, String nameSpace) {
            throw new IllegalStateException("leaf node can't have a child node");
        }

        @Override
        public Builder createChildBuilder(String name, String nameSpace, Object value) {
            throw new IllegalStateException("leaf node can't have a child node");
        }

        @Override
        public InnerNode.Builder deleteChild(NodeKey key) {
            throw new IllegalStateException("leaf node can't have a child node");
        }

        @Override
        public InnerNode.Builder getChildBuilder(NodeKey key) {
            throw new IllegalStateException("leaf node can't have a child node");
        }

        @Override
        public InnerNode.Builder addKeyLeaf(String name, String nameSpace, Object val) {
            throw new IllegalStateException("leaf node can't have a key leaves node");
        }

        @Override
        public Builder addLeafListValue(Object val) {
            LeafListKey.LeafListKeyBuilder leafListKeyBuilder;
            if (!(this.keyBuilder instanceof LeafListKey.LeafListKeyBuilder)) {
                if (this.keyBuilder instanceof ListKey.ListKeyBuilder) {
                    throw new ModelException("Leaf list is not a key of list");
                }
                leafListKeyBuilder = new LeafListKey.LeafListKeyBuilder();
                NodeKey key = this.keyBuilder.build();
                leafListKeyBuilder.schemaId(key.schemaId());
            } else {
                leafListKeyBuilder = (LeafListKey.LeafListKeyBuilder)this.keyBuilder;
            }
            leafListKeyBuilder.value(val);
            this.keyBuilder = leafListKeyBuilder;
            return this;
        }

        @Override
        public LeafNode build() {
            if (this.type == null) {
                throw new IllegalStateException("node should have a type.");
            }
            if (this.key == null) {
                this.key = this.keyBuilder.build();
            }
            return new LeafNode(this);
        }
    }
}

