/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.model.KeyLeaf;
import org.onosproject.yang.model.NodeKey;

public final class ListKey
extends NodeKey<ListKey>
implements Comparable<ListKey> {
    private List<KeyLeaf> keyLeafs;

    private ListKey(ListKeyBuilder builder) {
        super(builder);
        this.keyLeafs = builder.keyLeafs;
    }

    public List<KeyLeaf> keyLeafs() {
        return ImmutableList.copyOf(this.keyLeafs);
    }

    @Override
    public ListKey clone() throws CloneNotSupportedException {
        ListKey clonedListKey = (ListKey)super.clone();
        LinkedList<KeyLeaf> clonedKeyLeafs = new LinkedList<KeyLeaf>();
        for (KeyLeaf leaf : this.keyLeafs) {
            clonedKeyLeafs.add(leaf.clone());
        }
        clonedListKey.keyLeafs = clonedKeyLeafs;
        return clonedListKey;
    }

    @Override
    public int compareTo(ListKey o) {
        return 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schemaId, this.keyLeafs);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ListKey that = (ListKey)obj;
        List<KeyLeaf> thatList = that.keyLeafs;
        return this.keyLeafs.size() == thatList.size() && this.keyLeafs.containsAll(thatList) && Objects.equals(this.schemaId, that.schemaId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("value", this.keyLeafs).toString();
    }

    public static class ListKeyBuilder
    extends NodeKey.NodeKeyBuilder<ListKeyBuilder> {
        private List<KeyLeaf> keyLeafs = new LinkedList<KeyLeaf>();

        public ListKeyBuilder() {
        }

        public ListKeyBuilder(NodeKey.NodeKeyBuilder base) {
            super(base);
        }

        public void addKeyLeaf(String name, String nameSpace, Object val) {
            KeyLeaf keyLeaf = new KeyLeaf(name, nameSpace, val);
            this.keyLeafs.add(keyLeaf);
        }

        @Override
        public ListKey build() {
            return new ListKey(this);
        }
    }
}

