/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public class SchemaId
implements Comparable<SchemaId>,
Cloneable,
Serializable {
    private String name;
    private String nameSpace;

    private SchemaId() {
    }

    public SchemaId(String name, String nameSpace) {
        Preconditions.checkNotNull((Object)name, (Object)"Schema info is not complete");
        this.name = name;
        this.nameSpace = nameSpace;
    }

    public String name() {
        return this.name;
    }

    public String namespace() {
        return this.nameSpace;
    }

    public SchemaId clone() throws CloneNotSupportedException {
        return (SchemaId)super.clone();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nameSpace);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        SchemaId that = (SchemaId)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.nameSpace, that.nameSpace);
    }

    @Override
    public int compareTo(SchemaId o) {
        Preconditions.checkNotNull((Object)o);
        if (this.name.equals(o.name) && this.nameSpace.equals(o.nameSpace)) {
            return 0;
        }
        return -1;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.name).add("nameSpace", (Object)this.nameSpace).toString();
    }
}

