/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.api.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"primaryColor", "errorColor", "successColor", "warningColor", "infoColor"})
public class ThemeConfiguration {
    @JsonProperty(value="primaryColor")
    @JsonPropertyDescription(value="Primary color used in the UI, in hex code format or empty.")
    @Pattern(regexp="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$")
    @NotNull
    private @Pattern(regexp="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$") @NotNull String primaryColor;
    @JsonProperty(value="errorColor")
    @JsonPropertyDescription(value="Color used to indicate errors in the UI, in hex code format or empty")
    @Pattern(regexp="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$")
    @NotNull
    private @Pattern(regexp="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$") @NotNull String errorColor;
    @JsonProperty(value="successColor")
    @JsonPropertyDescription(value="Color used to indicate success in the UI, in hex code format or empty")
    @Pattern(regexp="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$")
    @NotNull
    private @Pattern(regexp="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$") @NotNull String successColor;
    @JsonProperty(value="warningColor")
    @JsonPropertyDescription(value="Color used to indicate warnings in the UI, in hex code format or empty")
    @Pattern(regexp="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$")
    @NotNull
    private @Pattern(regexp="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$") @NotNull String warningColor;
    @JsonProperty(value="infoColor")
    @JsonPropertyDescription(value="Color used for informational messages in the UI, in hex code format or empty")
    @Pattern(regexp="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$")
    @NotNull
    private @Pattern(regexp="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$") @NotNull String infoColor;

    @JsonProperty(value="primaryColor")
    public String getPrimaryColor() {
        return this.primaryColor;
    }

    @JsonProperty(value="primaryColor")
    public void setPrimaryColor(String primaryColor) {
        this.primaryColor = primaryColor;
    }

    public ThemeConfiguration withPrimaryColor(String primaryColor) {
        this.primaryColor = primaryColor;
        return this;
    }

    @JsonProperty(value="errorColor")
    public String getErrorColor() {
        return this.errorColor;
    }

    @JsonProperty(value="errorColor")
    public void setErrorColor(String errorColor) {
        this.errorColor = errorColor;
    }

    public ThemeConfiguration withErrorColor(String errorColor) {
        this.errorColor = errorColor;
        return this;
    }

    @JsonProperty(value="successColor")
    public String getSuccessColor() {
        return this.successColor;
    }

    @JsonProperty(value="successColor")
    public void setSuccessColor(String successColor) {
        this.successColor = successColor;
    }

    public ThemeConfiguration withSuccessColor(String successColor) {
        this.successColor = successColor;
        return this;
    }

    @JsonProperty(value="warningColor")
    public String getWarningColor() {
        return this.warningColor;
    }

    @JsonProperty(value="warningColor")
    public void setWarningColor(String warningColor) {
        this.warningColor = warningColor;
    }

    public ThemeConfiguration withWarningColor(String warningColor) {
        this.warningColor = warningColor;
        return this;
    }

    @JsonProperty(value="infoColor")
    public String getInfoColor() {
        return this.infoColor;
    }

    @JsonProperty(value="infoColor")
    public void setInfoColor(String infoColor) {
        this.infoColor = infoColor;
    }

    public ThemeConfiguration withInfoColor(String infoColor) {
        this.infoColor = infoColor;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ThemeConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("primaryColor");
        sb.append('=');
        sb.append(this.primaryColor == null ? "<null>" : this.primaryColor);
        sb.append(',');
        sb.append("errorColor");
        sb.append('=');
        sb.append(this.errorColor == null ? "<null>" : this.errorColor);
        sb.append(',');
        sb.append("successColor");
        sb.append('=');
        sb.append(this.successColor == null ? "<null>" : this.successColor);
        sb.append(',');
        sb.append("warningColor");
        sb.append('=');
        sb.append(this.warningColor == null ? "<null>" : this.warningColor);
        sb.append(',');
        sb.append("infoColor");
        sb.append('=');
        sb.append(this.infoColor == null ? "<null>" : this.infoColor);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.primaryColor == null ? 0 : this.primaryColor.hashCode());
        result = result * 31 + (this.warningColor == null ? 0 : this.warningColor.hashCode());
        result = result * 31 + (this.infoColor == null ? 0 : this.infoColor.hashCode());
        result = result * 31 + (this.errorColor == null ? 0 : this.errorColor.hashCode());
        result = result * 31 + (this.successColor == null ? 0 : this.successColor.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ThemeConfiguration)) {
            return false;
        }
        ThemeConfiguration rhs = (ThemeConfiguration)other;
        return (this.primaryColor == rhs.primaryColor || this.primaryColor != null && this.primaryColor.equals(rhs.primaryColor)) && (this.warningColor == rhs.warningColor || this.warningColor != null && this.warningColor.equals(rhs.warningColor)) && (this.infoColor == rhs.infoColor || this.infoColor != null && this.infoColor.equals(rhs.infoColor)) && (this.errorColor == rhs.errorColor || this.errorColor != null && this.errorColor.equals(rhs.errorColor)) && (this.successColor == rhs.successColor || this.successColor != null && this.successColor.equals(rhs.successColor));
    }
}

