/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.api.configuration.airflow;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.openmetadata.schema.tests.type.TestCaseStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"enabled", "onResult", "receivers", "sendToOwners"})
public class TestResultNotificationConfiguration {
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Is Test Notification Enabled?")
    private Boolean enabled = false;
    @JsonProperty(value="onResult")
    @JsonPropertyDescription(value="Send notification on Success, Failed or Aborted?")
    @Valid
    private List<TestCaseStatus> onResult = new ArrayList<TestCaseStatus>();
    @JsonProperty(value="receivers")
    @JsonPropertyDescription(value="Send notification on the mail")
    @Valid
    private List<String> receivers = new ArrayList<String>();
    @JsonProperty(value="sendToOwners")
    @JsonPropertyDescription(value="Send notification on the mail")
    private Boolean sendToOwners = false;

    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public TestResultNotificationConfiguration withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="onResult")
    public List<TestCaseStatus> getOnResult() {
        return this.onResult;
    }

    @JsonProperty(value="onResult")
    public void setOnResult(List<TestCaseStatus> onResult) {
        this.onResult = onResult;
    }

    public TestResultNotificationConfiguration withOnResult(List<TestCaseStatus> onResult) {
        this.onResult = onResult;
        return this;
    }

    @JsonProperty(value="receivers")
    public List<String> getReceivers() {
        return this.receivers;
    }

    @JsonProperty(value="receivers")
    public void setReceivers(List<String> receivers) {
        this.receivers = receivers;
    }

    public TestResultNotificationConfiguration withReceivers(List<String> receivers) {
        this.receivers = receivers;
        return this;
    }

    @JsonProperty(value="sendToOwners")
    public Boolean getSendToOwners() {
        return this.sendToOwners;
    }

    @JsonProperty(value="sendToOwners")
    public void setSendToOwners(Boolean sendToOwners) {
        this.sendToOwners = sendToOwners;
    }

    public TestResultNotificationConfiguration withSendToOwners(Boolean sendToOwners) {
        this.sendToOwners = sendToOwners;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestResultNotificationConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("enabled");
        sb.append('=');
        sb.append(this.enabled == null ? "<null>" : this.enabled);
        sb.append(',');
        sb.append("onResult");
        sb.append('=');
        sb.append(this.onResult == null ? "<null>" : this.onResult);
        sb.append(',');
        sb.append("receivers");
        sb.append('=');
        sb.append(this.receivers == null ? "<null>" : this.receivers);
        sb.append(',');
        sb.append("sendToOwners");
        sb.append('=');
        sb.append(this.sendToOwners == null ? "<null>" : this.sendToOwners);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sendToOwners == null ? 0 : this.sendToOwners.hashCode());
        result = result * 31 + (this.receivers == null ? 0 : this.receivers.hashCode());
        result = result * 31 + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = result * 31 + (this.onResult == null ? 0 : this.onResult.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TestResultNotificationConfiguration)) {
            return false;
        }
        TestResultNotificationConfiguration rhs = (TestResultNotificationConfiguration)other;
        return (this.sendToOwners == rhs.sendToOwners || this.sendToOwners != null && this.sendToOwners.equals(rhs.sendToOwners)) && (this.receivers == rhs.receivers || this.receivers != null && this.receivers.equals(rhs.receivers)) && (this.enabled == rhs.enabled || this.enabled != null && this.enabled.equals(rhs.enabled)) && (this.onResult == rhs.onResult || this.onResult != null && this.onResult.equals(rhs.onResult));
    }
}

