/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.type.Style;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.LifeCycle;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.Votes;
import org.openmetadata.schema.utils.EntityInterfaceUtil;

public interface EntityInterface {
    public static final Map<String, String> CANONICAL_ENTITY_NAME_MAP = new HashMap<String, String>();
    public static final Map<String, Class<? extends EntityInterface>> ENTITY_TYPE_TO_CLASS_MAP = new HashMap<String, Class<? extends EntityInterface>>();

    public UUID getId();

    public String getDescription();

    public String getDisplayName();

    public String getName();

    default public Boolean getDeleted() {
        return null;
    }

    public Double getVersion();

    public String getUpdatedBy();

    public Long getUpdatedAt();

    public URI getHref();

    public ChangeDescription getChangeDescription();

    default public List<EntityReference> getOwners() {
        return null;
    }

    default public List<TagLabel> getTags() {
        return null;
    }

    default public ProviderType getProvider() {
        return null;
    }

    default public List<EntityReference> getFollowers() {
        return null;
    }

    default public Votes getVotes() {
        return null;
    }

    public String getFullyQualifiedName();

    default public Object getExtension() {
        return null;
    }

    default public List<EntityReference> getChildren() {
        return null;
    }

    default public List<EntityReference> getReviewers() {
        return null;
    }

    default public List<EntityReference> getExperts() {
        return null;
    }

    default public EntityReference getDomain() {
        return null;
    }

    default public List<EntityReference> getDataProducts() {
        return null;
    }

    default public Style getStyle() {
        return null;
    }

    default public LifeCycle getLifeCycle() {
        return null;
    }

    public void setId(UUID var1);

    public void setDescription(String var1);

    public void setDisplayName(String var1);

    public void setName(String var1);

    public void setVersion(Double var1);

    public void setChangeDescription(ChangeDescription var1);

    public void setFullyQualifiedName(String var1);

    default public void setDeleted(Boolean flag) {
    }

    public void setUpdatedBy(String var1);

    public void setUpdatedAt(Long var1);

    public void setHref(URI var1);

    default public void setTags(List<TagLabel> tags) {
    }

    default public void setOwners(List<EntityReference> owners) {
    }

    default public void setExtension(Object extension) {
    }

    default public void setChildren(List<EntityReference> entityReference) {
    }

    default public void setReviewers(List<EntityReference> entityReference) {
    }

    default public void setExperts(List<EntityReference> entityReference) {
    }

    default public void setDomain(EntityReference entityReference) {
    }

    default public void setDataProducts(List<EntityReference> dataProducts) {
    }

    default public void setFollowers(List<EntityReference> followers) {
    }

    default public void setVotes(Votes vote) {
    }

    default public void setStyle(Style style) {
    }

    default public void setLifeCycle(LifeCycle lifeCycle) {
    }

    public <T extends EntityInterface> T withHref(URI var1);

    @JsonIgnore
    default public EntityReference getEntityReference() {
        return new EntityReference().withId(this.getId()).withName(this.getName()).withFullyQualifiedName(this.getFullyQualifiedName() == null ? EntityInterfaceUtil.quoteName(this.getName()) : this.getFullyQualifiedName()).withDescription(this.getDescription()).withDisplayName(CommonUtil.nullOrEmpty((String)this.getDisplayName()) ? this.getName() : this.getDisplayName()).withType(CANONICAL_ENTITY_NAME_MAP.get(this.getClass().getSimpleName().toLowerCase(Locale.ROOT))).withDeleted(this.getDeleted()).withHref(this.getHref());
    }
}

