/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.schema.type.EntityReference;

public interface EntityTimeSeriesInterface {
    public static final Map<String, String> CANONICAL_ENTITY_NAME_MAP = new HashMap<String, String>();
    public static final Map<String, Class<? extends EntityTimeSeriesInterface>> ENTITY_TYPE_TO_CLASS_MAP = new HashMap<String, Class<? extends EntityTimeSeriesInterface>>();

    public UUID getId();

    public Long getTimestamp();

    public void setId(UUID var1);

    @JsonIgnore
    default public Date getDateParsedTimestamp() {
        return new Date(this.getTimestamp());
    }

    @JsonIgnore
    default public String getStrParsedTimestamp() {
        Date date = new Date(this.getTimestamp());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format((Object)date);
    }

    @JsonIgnore
    default public String getIso8601StrDate() {
        Date date = new Date(this.getTimestamp());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format((Object)date);
    }

    @JsonIgnore
    default public EntityReference getEntityReference() {
        return new EntityReference().withId(this.getId()).withType(CANONICAL_ENTITY_NAME_MAP.get(this.getClass().getSimpleName().toLowerCase(Locale.ROOT)));
    }
}

