/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.analytics;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import org.openmetadata.schema.analytics.DataAssetMetrics;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"unusedDataAssets", "frequentlyUsedDataAssets", "totalSize", "totalCount", "serviceName", "serviceType", "entityType", "serviceOwner"})
public class AggregatedCostAnalysisReportData {
    @JsonProperty(value="unusedDataAssets")
    @JsonPropertyDescription(value="Store the Count and Size in bytes of the Data Assets over a time period")
    @Valid
    private DataAssetMetrics unusedDataAssets;
    @JsonProperty(value="frequentlyUsedDataAssets")
    @JsonPropertyDescription(value="Store the Count and Size in bytes of the Data Assets over a time period")
    @Valid
    private DataAssetMetrics frequentlyUsedDataAssets;
    @JsonProperty(value="totalSize")
    @JsonPropertyDescription(value="Total Size based in Bytes")
    private Double totalSize;
    @JsonProperty(value="totalCount")
    @JsonPropertyDescription(value="Total Count")
    private Double totalCount;
    @JsonProperty(value="serviceName")
    @JsonPropertyDescription(value="Name of the service")
    private String serviceName;
    @JsonProperty(value="serviceType")
    @JsonPropertyDescription(value="Type of the service")
    private String serviceType;
    @JsonProperty(value="entityType")
    @JsonPropertyDescription(value="Type of the entity")
    private String entityType;
    @JsonProperty(value="serviceOwner")
    @JsonPropertyDescription(value="Name of the service owner")
    private String serviceOwner;

    @JsonProperty(value="unusedDataAssets")
    public DataAssetMetrics getUnusedDataAssets() {
        return this.unusedDataAssets;
    }

    @JsonProperty(value="unusedDataAssets")
    public void setUnusedDataAssets(DataAssetMetrics unusedDataAssets) {
        this.unusedDataAssets = unusedDataAssets;
    }

    public AggregatedCostAnalysisReportData withUnusedDataAssets(DataAssetMetrics unusedDataAssets) {
        this.unusedDataAssets = unusedDataAssets;
        return this;
    }

    @JsonProperty(value="frequentlyUsedDataAssets")
    public DataAssetMetrics getFrequentlyUsedDataAssets() {
        return this.frequentlyUsedDataAssets;
    }

    @JsonProperty(value="frequentlyUsedDataAssets")
    public void setFrequentlyUsedDataAssets(DataAssetMetrics frequentlyUsedDataAssets) {
        this.frequentlyUsedDataAssets = frequentlyUsedDataAssets;
    }

    public AggregatedCostAnalysisReportData withFrequentlyUsedDataAssets(DataAssetMetrics frequentlyUsedDataAssets) {
        this.frequentlyUsedDataAssets = frequentlyUsedDataAssets;
        return this;
    }

    @JsonProperty(value="totalSize")
    public Double getTotalSize() {
        return this.totalSize;
    }

    @JsonProperty(value="totalSize")
    public void setTotalSize(Double totalSize) {
        this.totalSize = totalSize;
    }

    public AggregatedCostAnalysisReportData withTotalSize(Double totalSize) {
        this.totalSize = totalSize;
        return this;
    }

    @JsonProperty(value="totalCount")
    public Double getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="totalCount")
    public void setTotalCount(Double totalCount) {
        this.totalCount = totalCount;
    }

    public AggregatedCostAnalysisReportData withTotalCount(Double totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @JsonProperty(value="serviceName")
    public String getServiceName() {
        return this.serviceName;
    }

    @JsonProperty(value="serviceName")
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public AggregatedCostAnalysisReportData withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @JsonProperty(value="serviceType")
    public String getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public AggregatedCostAnalysisReportData withServiceType(String serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @JsonProperty(value="entityType")
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public AggregatedCostAnalysisReportData withEntityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonProperty(value="serviceOwner")
    public String getServiceOwner() {
        return this.serviceOwner;
    }

    @JsonProperty(value="serviceOwner")
    public void setServiceOwner(String serviceOwner) {
        this.serviceOwner = serviceOwner;
    }

    public AggregatedCostAnalysisReportData withServiceOwner(String serviceOwner) {
        this.serviceOwner = serviceOwner;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AggregatedCostAnalysisReportData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("unusedDataAssets");
        sb.append('=');
        sb.append(this.unusedDataAssets == null ? "<null>" : this.unusedDataAssets);
        sb.append(',');
        sb.append("frequentlyUsedDataAssets");
        sb.append('=');
        sb.append(this.frequentlyUsedDataAssets == null ? "<null>" : this.frequentlyUsedDataAssets);
        sb.append(',');
        sb.append("totalSize");
        sb.append('=');
        sb.append(this.totalSize == null ? "<null>" : this.totalSize);
        sb.append(',');
        sb.append("totalCount");
        sb.append('=');
        sb.append(this.totalCount == null ? "<null>" : this.totalCount);
        sb.append(',');
        sb.append("serviceName");
        sb.append('=');
        sb.append(this.serviceName == null ? "<null>" : this.serviceName);
        sb.append(',');
        sb.append("serviceType");
        sb.append('=');
        sb.append(this.serviceType == null ? "<null>" : this.serviceType);
        sb.append(',');
        sb.append("entityType");
        sb.append('=');
        sb.append(this.entityType == null ? "<null>" : this.entityType);
        sb.append(',');
        sb.append("serviceOwner");
        sb.append('=');
        sb.append(this.serviceOwner == null ? "<null>" : this.serviceOwner);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.serviceType == null ? 0 : this.serviceType.hashCode());
        result = result * 31 + (this.unusedDataAssets == null ? 0 : this.unusedDataAssets.hashCode());
        result = result * 31 + (this.totalSize == null ? 0 : this.totalSize.hashCode());
        result = result * 31 + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = result * 31 + (this.serviceOwner == null ? 0 : this.serviceOwner.hashCode());
        result = result * 31 + (this.totalCount == null ? 0 : this.totalCount.hashCode());
        result = result * 31 + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = result * 31 + (this.frequentlyUsedDataAssets == null ? 0 : this.frequentlyUsedDataAssets.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AggregatedCostAnalysisReportData)) {
            return false;
        }
        AggregatedCostAnalysisReportData rhs = (AggregatedCostAnalysisReportData)other;
        return (this.serviceType == rhs.serviceType || this.serviceType != null && this.serviceType.equals(rhs.serviceType)) && (this.unusedDataAssets == rhs.unusedDataAssets || this.unusedDataAssets != null && this.unusedDataAssets.equals(rhs.unusedDataAssets)) && (this.totalSize == rhs.totalSize || this.totalSize != null && this.totalSize.equals(rhs.totalSize)) && (this.entityType == rhs.entityType || this.entityType != null && this.entityType.equals(rhs.entityType)) && (this.serviceOwner == rhs.serviceOwner || this.serviceOwner != null && this.serviceOwner.equals(rhs.serviceOwner)) && (this.totalCount == rhs.totalCount || this.totalCount != null && this.totalCount.equals(rhs.totalCount)) && (this.serviceName == rhs.serviceName || this.serviceName != null && this.serviceName.equals(rhs.serviceName)) && (this.frequentlyUsedDataAssets == rhs.frequentlyUsedDataAssets || this.frequentlyUsedDataAssets != null && this.frequentlyUsedDataAssets.equals(rhs.frequentlyUsedDataAssets));
    }
}

