/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.analytics;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fullUrl", "url", "hostname", "language", "screenSize", "userId", "sessionId", "pageLoadTime", "referrer"})
public class PageViewData {
    @JsonProperty(value="fullUrl")
    @JsonPropertyDescription(value="complete URL of the page")
    private String fullUrl;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="url part after the domain specification")
    private String url;
    @JsonProperty(value="hostname")
    @JsonPropertyDescription(value="domain name")
    private String hostname;
    @JsonProperty(value="language")
    @JsonPropertyDescription(value="language set on the page")
    private String language;
    @JsonProperty(value="screenSize")
    @JsonPropertyDescription(value="Size of the screen")
    private String screenSize;
    @JsonProperty(value="userId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID userId;
    @JsonProperty(value="sessionId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID sessionId;
    @JsonProperty(value="pageLoadTime")
    @JsonPropertyDescription(value="time for the page to load in seconds")
    private Double pageLoadTime;
    @JsonProperty(value="referrer")
    @JsonPropertyDescription(value="referrer URL")
    private String referrer;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="fullUrl")
    public String getFullUrl() {
        return this.fullUrl;
    }

    @JsonProperty(value="fullUrl")
    public void setFullUrl(String fullUrl) {
        this.fullUrl = fullUrl;
    }

    public PageViewData withFullUrl(String fullUrl) {
        this.fullUrl = fullUrl;
        return this;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    public PageViewData withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty(value="hostname")
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty(value="hostname")
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public PageViewData withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    public PageViewData withLanguage(String language) {
        this.language = language;
        return this;
    }

    @JsonProperty(value="screenSize")
    public String getScreenSize() {
        return this.screenSize;
    }

    @JsonProperty(value="screenSize")
    public void setScreenSize(String screenSize) {
        this.screenSize = screenSize;
    }

    public PageViewData withScreenSize(String screenSize) {
        this.screenSize = screenSize;
        return this;
    }

    @JsonProperty(value="userId")
    public UUID getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public PageViewData withUserId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @JsonProperty(value="sessionId")
    public UUID getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="sessionId")
    public void setSessionId(UUID sessionId) {
        this.sessionId = sessionId;
    }

    public PageViewData withSessionId(UUID sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @JsonProperty(value="pageLoadTime")
    public Double getPageLoadTime() {
        return this.pageLoadTime;
    }

    @JsonProperty(value="pageLoadTime")
    public void setPageLoadTime(Double pageLoadTime) {
        this.pageLoadTime = pageLoadTime;
    }

    public PageViewData withPageLoadTime(Double pageLoadTime) {
        this.pageLoadTime = pageLoadTime;
        return this;
    }

    @JsonProperty(value="referrer")
    public String getReferrer() {
        return this.referrer;
    }

    @JsonProperty(value="referrer")
    public void setReferrer(String referrer) {
        this.referrer = referrer;
    }

    public PageViewData withReferrer(String referrer) {
        this.referrer = referrer;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public PageViewData withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PageViewData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("fullUrl");
        sb.append('=');
        sb.append(this.fullUrl == null ? "<null>" : this.fullUrl);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("hostname");
        sb.append('=');
        sb.append(this.hostname == null ? "<null>" : this.hostname);
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(this.language == null ? "<null>" : this.language);
        sb.append(',');
        sb.append("screenSize");
        sb.append('=');
        sb.append(this.screenSize == null ? "<null>" : this.screenSize);
        sb.append(',');
        sb.append("userId");
        sb.append('=');
        sb.append(this.userId == null ? "<null>" : this.userId);
        sb.append(',');
        sb.append("sessionId");
        sb.append('=');
        sb.append(this.sessionId == null ? "<null>" : this.sessionId);
        sb.append(',');
        sb.append("pageLoadTime");
        sb.append('=');
        sb.append(this.pageLoadTime == null ? "<null>" : this.pageLoadTime);
        sb.append(',');
        sb.append("referrer");
        sb.append('=');
        sb.append(this.referrer == null ? "<null>" : this.referrer);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.referrer == null ? 0 : this.referrer.hashCode());
        result = result * 31 + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = result * 31 + (this.screenSize == null ? 0 : this.screenSize.hashCode());
        result = result * 31 + (this.fullUrl == null ? 0 : this.fullUrl.hashCode());
        result = result * 31 + (this.language == null ? 0 : this.language.hashCode());
        result = result * 31 + (this.pageLoadTime == null ? 0 : this.pageLoadTime.hashCode());
        result = result * 31 + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.userId == null ? 0 : this.userId.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PageViewData)) {
            return false;
        }
        PageViewData rhs = (PageViewData)other;
        return (this.referrer == rhs.referrer || this.referrer != null && this.referrer.equals(rhs.referrer)) && (this.hostname == rhs.hostname || this.hostname != null && this.hostname.equals(rhs.hostname)) && (this.screenSize == rhs.screenSize || this.screenSize != null && this.screenSize.equals(rhs.screenSize)) && (this.fullUrl == rhs.fullUrl || this.fullUrl != null && this.fullUrl.equals(rhs.fullUrl)) && (this.language == rhs.language || this.language != null && this.language.equals(rhs.language)) && (this.pageLoadTime == rhs.pageLoadTime || this.pageLoadTime != null && this.pageLoadTime.equals(rhs.pageLoadTime)) && (this.sessionId == rhs.sessionId || this.sessionId != null && this.sessionId.equals(rhs.sessionId)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.userId == rhs.userId || this.userId != null && this.userId.equals(rhs.userId)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url));
    }
}

