/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.analytics;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.LifeCycle;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"entity", "lifeCycle", "sizeInByte"})
public class RawCostAnalysisReportData {
    @JsonProperty(value="entity")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    @NotNull
    private EntityReference entity;
    @JsonProperty(value="lifeCycle")
    @JsonPropertyDescription(value="This schema defines Life Cycle Properties.")
    @Valid
    private LifeCycle lifeCycle;
    @JsonProperty(value="sizeInByte")
    @JsonPropertyDescription(value="Entity size in bytes")
    private Double sizeInByte;

    @JsonProperty(value="entity")
    public EntityReference getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    public void setEntity(EntityReference entity) {
        this.entity = entity;
    }

    public RawCostAnalysisReportData withEntity(EntityReference entity) {
        this.entity = entity;
        return this;
    }

    @JsonProperty(value="lifeCycle")
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public RawCostAnalysisReportData withLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @JsonProperty(value="sizeInByte")
    public Double getSizeInByte() {
        return this.sizeInByte;
    }

    @JsonProperty(value="sizeInByte")
    public void setSizeInByte(Double sizeInByte) {
        this.sizeInByte = sizeInByte;
    }

    public RawCostAnalysisReportData withSizeInByte(Double sizeInByte) {
        this.sizeInByte = sizeInByte;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RawCostAnalysisReportData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("entity");
        sb.append('=');
        sb.append(this.entity == null ? "<null>" : this.entity);
        sb.append(',');
        sb.append("lifeCycle");
        sb.append('=');
        sb.append(this.lifeCycle == null ? "<null>" : this.lifeCycle);
        sb.append(',');
        sb.append("sizeInByte");
        sb.append('=');
        sb.append(this.sizeInByte == null ? "<null>" : this.sizeInByte);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.lifeCycle == null ? 0 : this.lifeCycle.hashCode());
        result = result * 31 + (this.sizeInByte == null ? 0 : this.sizeInByte.hashCode());
        result = result * 31 + (this.entity == null ? 0 : this.entity.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RawCostAnalysisReportData)) {
            return false;
        }
        RawCostAnalysisReportData rhs = (RawCostAnalysisReportData)other;
        return (this.lifeCycle == rhs.lifeCycle || this.lifeCycle != null && this.lifeCycle.equals(rhs.lifeCycle)) && (this.sizeInByte == rhs.sizeInByte || this.sizeInByte != null && this.sizeInByte.equals(rhs.sizeInByte)) && (this.entity == rhs.entity || this.entity != null && this.entity.equals(rhs.entity));
    }
}

