/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.analytics;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.EntityTimeSeriesInterface;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "timestamp", "reportDataType", "data"})
public class ReportData
implements EntityTimeSeriesInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID id;
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long timestamp;
    @JsonProperty(value="reportDataType")
    @JsonPropertyDescription(value="Type of data")
    private ReportDataType reportDataType;
    @JsonProperty(value="data")
    @JsonPropertyDescription(value="Data captured")
    private Object data;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public ReportData withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public ReportData withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="reportDataType")
    public ReportDataType getReportDataType() {
        return this.reportDataType;
    }

    @JsonProperty(value="reportDataType")
    public void setReportDataType(ReportDataType reportDataType) {
        this.reportDataType = reportDataType;
    }

    public ReportData withReportDataType(ReportDataType reportDataType) {
        this.reportDataType = reportDataType;
        return this;
    }

    @JsonProperty(value="data")
    public Object getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(Object data) {
        this.data = data;
    }

    public ReportData withData(Object data) {
        this.data = data;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ReportData withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ReportData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("reportDataType");
        sb.append('=');
        sb.append(this.reportDataType == null ? "<null>" : this.reportDataType);
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(this.data == null ? "<null>" : this.data);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.reportDataType == null ? 0 : this.reportDataType.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ReportData)) {
            return false;
        }
        ReportData rhs = (ReportData)other;
        return (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.reportDataType == rhs.reportDataType || this.reportDataType != null && this.reportDataType.equals((Object)rhs.reportDataType)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.data == rhs.data || this.data != null && this.data.equals(rhs.data)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }

    public static enum ReportDataType {
        ENTITY_REPORT_DATA("entityReportData"),
        WEB_ANALYTIC_USER_ACTIVITY_REPORT_DATA("webAnalyticUserActivityReportData"),
        WEB_ANALYTIC_ENTITY_VIEW_REPORT_DATA("webAnalyticEntityViewReportData"),
        RAW_COST_ANALYSIS_REPORT_DATA("rawCostAnalysisReportData"),
        AGGREGATED_COST_ANALYSIS_REPORT_DATA("aggregatedCostAnalysisReportData");

        private final String value;
        private static final Map<String, ReportDataType> CONSTANTS;

        private ReportDataType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ReportDataType fromValue(String value) {
            ReportDataType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ReportDataType>();
            for (ReportDataType c : ReportDataType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

