/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.analytics;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"entityType", "entityTier", "entityFqn", "entityHref", "tagsFQN", "owner", "ownerId", "views"})
public class WebAnalyticEntityViewReportData {
    @JsonProperty(value="entityType")
    @JsonPropertyDescription(value="entity type")
    private String entityType;
    @JsonProperty(value="entityTier")
    @JsonPropertyDescription(value="entity tier")
    private String entityTier;
    @JsonProperty(value="entityFqn")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String entityFqn;
    @JsonProperty(value="entityHref")
    @JsonPropertyDescription(value="entity href")
    private String entityHref;
    @JsonProperty(value="tagsFQN")
    @JsonPropertyDescription(value="Tags FQN")
    @Valid
    private List<String> tagsFQN = new ArrayList<String>();
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="Name of the entity owner")
    private String owner;
    @JsonProperty(value="ownerId")
    @JsonPropertyDescription(value="Name of the entity owner")
    private String ownerId;
    @JsonProperty(value="views")
    @JsonPropertyDescription(value="Number of time the entity was viewed")
    private Integer views;

    @JsonProperty(value="entityType")
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public WebAnalyticEntityViewReportData withEntityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonProperty(value="entityTier")
    public String getEntityTier() {
        return this.entityTier;
    }

    @JsonProperty(value="entityTier")
    public void setEntityTier(String entityTier) {
        this.entityTier = entityTier;
    }

    public WebAnalyticEntityViewReportData withEntityTier(String entityTier) {
        this.entityTier = entityTier;
        return this;
    }

    @JsonProperty(value="entityFqn")
    public String getEntityFqn() {
        return this.entityFqn;
    }

    @JsonProperty(value="entityFqn")
    public void setEntityFqn(String entityFqn) {
        this.entityFqn = entityFqn;
    }

    public WebAnalyticEntityViewReportData withEntityFqn(String entityFqn) {
        this.entityFqn = entityFqn;
        return this;
    }

    @JsonProperty(value="entityHref")
    public String getEntityHref() {
        return this.entityHref;
    }

    @JsonProperty(value="entityHref")
    public void setEntityHref(String entityHref) {
        this.entityHref = entityHref;
    }

    public WebAnalyticEntityViewReportData withEntityHref(String entityHref) {
        this.entityHref = entityHref;
        return this;
    }

    @JsonProperty(value="tagsFQN")
    public List<String> getTagsFQN() {
        return this.tagsFQN;
    }

    @JsonProperty(value="tagsFQN")
    public void setTagsFQN(List<String> tagsFQN) {
        this.tagsFQN = tagsFQN;
    }

    public WebAnalyticEntityViewReportData withTagsFQN(List<String> tagsFQN) {
        this.tagsFQN = tagsFQN;
        return this;
    }

    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(String owner) {
        this.owner = owner;
    }

    public WebAnalyticEntityViewReportData withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="ownerId")
    public String getOwnerId() {
        return this.ownerId;
    }

    @JsonProperty(value="ownerId")
    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public WebAnalyticEntityViewReportData withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @JsonProperty(value="views")
    public Integer getViews() {
        return this.views;
    }

    @JsonProperty(value="views")
    public void setViews(Integer views) {
        this.views = views;
    }

    public WebAnalyticEntityViewReportData withViews(Integer views) {
        this.views = views;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(WebAnalyticEntityViewReportData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("entityType");
        sb.append('=');
        sb.append(this.entityType == null ? "<null>" : this.entityType);
        sb.append(',');
        sb.append("entityTier");
        sb.append('=');
        sb.append(this.entityTier == null ? "<null>" : this.entityTier);
        sb.append(',');
        sb.append("entityFqn");
        sb.append('=');
        sb.append(this.entityFqn == null ? "<null>" : this.entityFqn);
        sb.append(',');
        sb.append("entityHref");
        sb.append('=');
        sb.append(this.entityHref == null ? "<null>" : this.entityHref);
        sb.append(',');
        sb.append("tagsFQN");
        sb.append('=');
        sb.append(this.tagsFQN == null ? "<null>" : this.tagsFQN);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("ownerId");
        sb.append('=');
        sb.append(this.ownerId == null ? "<null>" : this.ownerId);
        sb.append(',');
        sb.append("views");
        sb.append('=');
        sb.append(this.views == null ? "<null>" : this.views);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.tagsFQN == null ? 0 : this.tagsFQN.hashCode());
        result = result * 31 + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = result * 31 + (this.entityFqn == null ? 0 : this.entityFqn.hashCode());
        result = result * 31 + (this.entityHref == null ? 0 : this.entityHref.hashCode());
        result = result * 31 + (this.ownerId == null ? 0 : this.ownerId.hashCode());
        result = result * 31 + (this.entityTier == null ? 0 : this.entityTier.hashCode());
        result = result * 31 + (this.views == null ? 0 : this.views.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof WebAnalyticEntityViewReportData)) {
            return false;
        }
        WebAnalyticEntityViewReportData rhs = (WebAnalyticEntityViewReportData)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.tagsFQN == rhs.tagsFQN || this.tagsFQN != null && this.tagsFQN.equals(rhs.tagsFQN)) && (this.entityType == rhs.entityType || this.entityType != null && this.entityType.equals(rhs.entityType)) && (this.entityFqn == rhs.entityFqn || this.entityFqn != null && this.entityFqn.equals(rhs.entityFqn)) && (this.entityHref == rhs.entityHref || this.entityHref != null && this.entityHref.equals(rhs.entityHref)) && (this.ownerId == rhs.ownerId || this.ownerId != null && this.ownerId.equals(rhs.ownerId)) && (this.entityTier == rhs.entityTier || this.entityTier != null && this.entityTier.equals(rhs.entityTier)) && (this.views == rhs.views || this.views != null && this.views.equals(rhs.views));
    }
}

