/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"operation", "dryRun", "glossaryTags", "assets"})
public class AddGlossaryToAssetsRequest {
    @JsonProperty(value="operation")
    @JsonPropertyDescription(value="Operation to be performed")
    private Operation operation;
    @JsonProperty(value="dryRun")
    @JsonPropertyDescription(value="If true, the request will be validated but no changes will be made")
    private Boolean dryRun = true;
    @JsonProperty(value="glossaryTags")
    @JsonPropertyDescription(value="Glossary Tags to be added")
    @Valid
    private List<TagLabel> glossaryTags = null;
    @JsonProperty(value="assets")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> assets = null;

    @JsonProperty(value="operation")
    public Operation getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public AddGlossaryToAssetsRequest withOperation(Operation operation) {
        this.operation = operation;
        return this;
    }

    @JsonProperty(value="dryRun")
    public Boolean getDryRun() {
        return this.dryRun;
    }

    @JsonProperty(value="dryRun")
    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public AddGlossaryToAssetsRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @JsonProperty(value="glossaryTags")
    public List<TagLabel> getGlossaryTags() {
        return this.glossaryTags;
    }

    @JsonProperty(value="glossaryTags")
    public void setGlossaryTags(List<TagLabel> glossaryTags) {
        this.glossaryTags = glossaryTags;
    }

    public AddGlossaryToAssetsRequest withGlossaryTags(List<TagLabel> glossaryTags) {
        this.glossaryTags = glossaryTags;
        return this;
    }

    @JsonProperty(value="assets")
    public List<EntityReference> getAssets() {
        return this.assets;
    }

    @JsonProperty(value="assets")
    public void setAssets(List<EntityReference> assets) {
        this.assets = assets;
    }

    public AddGlossaryToAssetsRequest withAssets(List<EntityReference> assets) {
        this.assets = assets;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AddGlossaryToAssetsRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("operation");
        sb.append('=');
        sb.append(this.operation == null ? "<null>" : this.operation);
        sb.append(',');
        sb.append("dryRun");
        sb.append('=');
        sb.append(this.dryRun == null ? "<null>" : this.dryRun);
        sb.append(',');
        sb.append("glossaryTags");
        sb.append('=');
        sb.append(this.glossaryTags == null ? "<null>" : this.glossaryTags);
        sb.append(',');
        sb.append("assets");
        sb.append('=');
        sb.append(this.assets == null ? "<null>" : this.assets);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.glossaryTags == null ? 0 : this.glossaryTags.hashCode());
        result = result * 31 + (this.dryRun == null ? 0 : this.dryRun.hashCode());
        result = result * 31 + (this.assets == null ? 0 : this.assets.hashCode());
        result = result * 31 + (this.operation == null ? 0 : this.operation.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AddGlossaryToAssetsRequest)) {
            return false;
        }
        AddGlossaryToAssetsRequest rhs = (AddGlossaryToAssetsRequest)other;
        return (this.glossaryTags == rhs.glossaryTags || this.glossaryTags != null && this.glossaryTags.equals(rhs.glossaryTags)) && (this.dryRun == rhs.dryRun || this.dryRun != null && this.dryRun.equals(rhs.dryRun)) && (this.assets == rhs.assets || this.assets != null && this.assets.equals(rhs.assets)) && (this.operation == rhs.operation || this.operation != null && this.operation.equals((Object)rhs.operation));
    }

    public static enum Operation {
        ADD_ASSETS("AddAssets"),
        ADD_GLOSSARY_TAGS("AddGlossaryTags");

        private final String value;
        private static final Map<String, Operation> CONSTANTS;

        private Operation(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Operation fromValue(String value) {
            Operation constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Operation>();
            for (Operation c : Operation.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

