/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TaskType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "assignees", "oldValue", "suggestion"})
public class CreateTaskDetails {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type of a task.")
    @NotNull
    private TaskType type;
    @JsonProperty(value="assignees")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    @NotNull
    private List<EntityReference> assignees = null;
    @JsonProperty(value="oldValue")
    @JsonPropertyDescription(value="The value of old object for which the task is created.")
    private String oldValue;
    @JsonProperty(value="suggestion")
    @JsonPropertyDescription(value="The suggestion object for the task provided by the creator.")
    private String suggestion;

    @JsonProperty(value="type")
    public TaskType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(TaskType type) {
        this.type = type;
    }

    public CreateTaskDetails withType(TaskType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="assignees")
    public List<EntityReference> getAssignees() {
        return this.assignees;
    }

    @JsonProperty(value="assignees")
    public void setAssignees(List<EntityReference> assignees) {
        this.assignees = assignees;
    }

    public CreateTaskDetails withAssignees(List<EntityReference> assignees) {
        this.assignees = assignees;
        return this;
    }

    @JsonProperty(value="oldValue")
    public String getOldValue() {
        return this.oldValue;
    }

    @JsonProperty(value="oldValue")
    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public CreateTaskDetails withOldValue(String oldValue) {
        this.oldValue = oldValue;
        return this;
    }

    @JsonProperty(value="suggestion")
    public String getSuggestion() {
        return this.suggestion;
    }

    @JsonProperty(value="suggestion")
    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public CreateTaskDetails withSuggestion(String suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateTaskDetails.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("assignees");
        sb.append('=');
        sb.append(this.assignees == null ? "<null>" : this.assignees);
        sb.append(',');
        sb.append("oldValue");
        sb.append('=');
        sb.append(this.oldValue == null ? "<null>" : this.oldValue);
        sb.append(',');
        sb.append("suggestion");
        sb.append('=');
        sb.append(this.suggestion == null ? "<null>" : this.suggestion);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.assignees == null ? 0 : this.assignees.hashCode());
        result = result * 31 + (this.oldValue == null ? 0 : this.oldValue.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.suggestion == null ? 0 : this.suggestion.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateTaskDetails)) {
            return false;
        }
        CreateTaskDetails rhs = (CreateTaskDetails)other;
        return (this.assignees == rhs.assignees || this.assignees != null && this.assignees.equals(rhs.assignees)) && (this.oldValue == rhs.oldValue || this.oldValue != null && this.oldValue.equals(rhs.oldValue)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.suggestion == rhs.suggestion || this.suggestion != null && this.suggestion.equals(rhs.suggestion));
    }
}

